/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class VolumeMount
implements JsonSerializable<VolumeMount> {
    private String volumeName;
    private String mountPath;
    private String subPath;

    public String volumeName() {
        return this.volumeName;
    }

    public VolumeMount withVolumeName(String volumeName) {
        this.volumeName = volumeName;
        return this;
    }

    public String mountPath() {
        return this.mountPath;
    }

    public VolumeMount withMountPath(String mountPath) {
        this.mountPath = mountPath;
        return this;
    }

    public String subPath() {
        return this.subPath;
    }

    public VolumeMount withSubPath(String subPath) {
        this.subPath = subPath;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("volumeName", this.volumeName);
        jsonWriter.writeStringField("mountPath", this.mountPath);
        jsonWriter.writeStringField("subPath", this.subPath);
        return jsonWriter.writeEndObject();
    }

    public static VolumeMount fromJson(JsonReader jsonReader) throws IOException {
        return (VolumeMount)jsonReader.readObject(reader -> {
            VolumeMount deserializedVolumeMount = new VolumeMount();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("volumeName".equals(fieldName)) {
                    deserializedVolumeMount.volumeName = reader.getString();
                    continue;
                }
                if ("mountPath".equals(fieldName)) {
                    deserializedVolumeMount.mountPath = reader.getString();
                    continue;
                }
                if ("subPath".equals(fieldName)) {
                    deserializedVolumeMount.subPath = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVolumeMount;
        });
    }
}

