/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class TrafficWeight
implements JsonSerializable<TrafficWeight> {
    private String revisionName;
    private Integer weight;
    private Boolean latestRevision;
    private String label;

    public String revisionName() {
        return this.revisionName;
    }

    public TrafficWeight withRevisionName(String revisionName) {
        this.revisionName = revisionName;
        return this;
    }

    public Integer weight() {
        return this.weight;
    }

    public TrafficWeight withWeight(Integer weight) {
        this.weight = weight;
        return this;
    }

    public Boolean latestRevision() {
        return this.latestRevision;
    }

    public TrafficWeight withLatestRevision(Boolean latestRevision) {
        this.latestRevision = latestRevision;
        return this;
    }

    public String label() {
        return this.label;
    }

    public TrafficWeight withLabel(String label) {
        this.label = label;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("revisionName", this.revisionName);
        jsonWriter.writeNumberField("weight", (Number)this.weight);
        jsonWriter.writeBooleanField("latestRevision", this.latestRevision);
        jsonWriter.writeStringField("label", this.label);
        return jsonWriter.writeEndObject();
    }

    public static TrafficWeight fromJson(JsonReader jsonReader) throws IOException {
        return (TrafficWeight)jsonReader.readObject(reader -> {
            TrafficWeight deserializedTrafficWeight = new TrafficWeight();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("revisionName".equals(fieldName)) {
                    deserializedTrafficWeight.revisionName = reader.getString();
                    continue;
                }
                if ("weight".equals(fieldName)) {
                    deserializedTrafficWeight.weight = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("latestRevision".equals(fieldName)) {
                    deserializedTrafficWeight.latestRevision = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("label".equals(fieldName)) {
                    deserializedTrafficWeight.label = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTrafficWeight;
        });
    }
}

