/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.SessionPoolUpdatablePropertiesProperties;
import com.azure.resourcemanager.appcontainers.models.CustomContainerTemplate;
import com.azure.resourcemanager.appcontainers.models.DynamicPoolConfiguration;
import com.azure.resourcemanager.appcontainers.models.ManagedServiceIdentity;
import com.azure.resourcemanager.appcontainers.models.ScaleConfiguration;
import com.azure.resourcemanager.appcontainers.models.SessionNetworkConfiguration;
import com.azure.resourcemanager.appcontainers.models.SessionPoolSecret;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class SessionPoolUpdatableProperties
implements JsonSerializable<SessionPoolUpdatableProperties> {
    private Map<String, String> tags;
    private ManagedServiceIdentity identity;
    private SessionPoolUpdatablePropertiesProperties innerProperties;

    public Map<String, String> tags() {
        return this.tags;
    }

    public SessionPoolUpdatableProperties withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public SessionPoolUpdatableProperties withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    private SessionPoolUpdatablePropertiesProperties innerProperties() {
        return this.innerProperties;
    }

    public ScaleConfiguration scaleConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().scaleConfiguration();
    }

    public SessionPoolUpdatableProperties withScaleConfiguration(ScaleConfiguration scaleConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SessionPoolUpdatablePropertiesProperties();
        }
        this.innerProperties().withScaleConfiguration(scaleConfiguration);
        return this;
    }

    public List<SessionPoolSecret> secrets() {
        return this.innerProperties() == null ? null : this.innerProperties().secrets();
    }

    public SessionPoolUpdatableProperties withSecrets(List<SessionPoolSecret> secrets) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SessionPoolUpdatablePropertiesProperties();
        }
        this.innerProperties().withSecrets(secrets);
        return this;
    }

    public DynamicPoolConfiguration dynamicPoolConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().dynamicPoolConfiguration();
    }

    public SessionPoolUpdatableProperties withDynamicPoolConfiguration(DynamicPoolConfiguration dynamicPoolConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SessionPoolUpdatablePropertiesProperties();
        }
        this.innerProperties().withDynamicPoolConfiguration(dynamicPoolConfiguration);
        return this;
    }

    public CustomContainerTemplate customContainerTemplate() {
        return this.innerProperties() == null ? null : this.innerProperties().customContainerTemplate();
    }

    public SessionPoolUpdatableProperties withCustomContainerTemplate(CustomContainerTemplate customContainerTemplate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SessionPoolUpdatablePropertiesProperties();
        }
        this.innerProperties().withCustomContainerTemplate(customContainerTemplate);
        return this;
    }

    public SessionNetworkConfiguration sessionNetworkConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().sessionNetworkConfiguration();
    }

    public SessionPoolUpdatableProperties withSessionNetworkConfiguration(SessionNetworkConfiguration sessionNetworkConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SessionPoolUpdatablePropertiesProperties();
        }
        this.innerProperties().withSessionNetworkConfiguration(sessionNetworkConfiguration);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SessionPoolUpdatableProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SessionPoolUpdatableProperties)jsonReader.readObject(reader -> {
            SessionPoolUpdatableProperties deserializedSessionPoolUpdatableProperties = new SessionPoolUpdatableProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedSessionPoolUpdatableProperties.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedSessionPoolUpdatableProperties.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSessionPoolUpdatableProperties.innerProperties = SessionPoolUpdatablePropertiesProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSessionPoolUpdatableProperties;
        });
    }
}

