/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.JobExecutionContainer;
import java.io.IOException;
import java.util.List;

public final class JobExecutionTemplate
implements JsonSerializable<JobExecutionTemplate> {
    private List<JobExecutionContainer> containers;
    private List<JobExecutionContainer> initContainers;

    public List<JobExecutionContainer> containers() {
        return this.containers;
    }

    public JobExecutionTemplate withContainers(List<JobExecutionContainer> containers) {
        this.containers = containers;
        return this;
    }

    public List<JobExecutionContainer> initContainers() {
        return this.initContainers;
    }

    public JobExecutionTemplate withInitContainers(List<JobExecutionContainer> initContainers) {
        this.initContainers = initContainers;
        return this;
    }

    public void validate() {
        if (this.containers() != null) {
            this.containers().forEach(e -> e.validate());
        }
        if (this.initContainers() != null) {
            this.initContainers().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("containers", this.containers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("initContainers", this.initContainers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static JobExecutionTemplate fromJson(JsonReader jsonReader) throws IOException {
        return (JobExecutionTemplate)jsonReader.readObject(reader -> {
            JobExecutionTemplate deserializedJobExecutionTemplate = new JobExecutionTemplate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("containers".equals(fieldName)) {
                    List containers;
                    deserializedJobExecutionTemplate.containers = containers = reader.readArray(reader1 -> JobExecutionContainer.fromJson(reader1));
                    continue;
                }
                if ("initContainers".equals(fieldName)) {
                    List initContainers;
                    deserializedJobExecutionTemplate.initContainers = initContainers = reader.readArray(reader1 -> JobExecutionContainer.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobExecutionTemplate;
        });
    }
}

