/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.CorsPolicy;
import com.azure.resourcemanager.appcontainers.models.CustomDomain;
import com.azure.resourcemanager.appcontainers.models.IngressClientCertificateMode;
import com.azure.resourcemanager.appcontainers.models.IngressPortMapping;
import com.azure.resourcemanager.appcontainers.models.IngressStickySessions;
import com.azure.resourcemanager.appcontainers.models.IngressTransportMethod;
import com.azure.resourcemanager.appcontainers.models.IpSecurityRestrictionRule;
import com.azure.resourcemanager.appcontainers.models.TrafficWeight;
import java.io.IOException;
import java.util.List;

public final class Ingress
implements JsonSerializable<Ingress> {
    private String fqdn;
    private Boolean external;
    private Integer targetPort;
    private Integer exposedPort;
    private IngressTransportMethod transport;
    private List<TrafficWeight> traffic;
    private List<CustomDomain> customDomains;
    private Boolean allowInsecure;
    private List<IpSecurityRestrictionRule> ipSecurityRestrictions;
    private IngressStickySessions stickySessions;
    private IngressClientCertificateMode clientCertificateMode;
    private CorsPolicy corsPolicy;
    private List<IngressPortMapping> additionalPortMappings;

    public String fqdn() {
        return this.fqdn;
    }

    public Boolean external() {
        return this.external;
    }

    public Ingress withExternal(Boolean external) {
        this.external = external;
        return this;
    }

    public Integer targetPort() {
        return this.targetPort;
    }

    public Ingress withTargetPort(Integer targetPort) {
        this.targetPort = targetPort;
        return this;
    }

    public Integer exposedPort() {
        return this.exposedPort;
    }

    public Ingress withExposedPort(Integer exposedPort) {
        this.exposedPort = exposedPort;
        return this;
    }

    public IngressTransportMethod transport() {
        return this.transport;
    }

    public Ingress withTransport(IngressTransportMethod transport) {
        this.transport = transport;
        return this;
    }

    public List<TrafficWeight> traffic() {
        return this.traffic;
    }

    public Ingress withTraffic(List<TrafficWeight> traffic) {
        this.traffic = traffic;
        return this;
    }

    public List<CustomDomain> customDomains() {
        return this.customDomains;
    }

    public Ingress withCustomDomains(List<CustomDomain> customDomains) {
        this.customDomains = customDomains;
        return this;
    }

    public Boolean allowInsecure() {
        return this.allowInsecure;
    }

    public Ingress withAllowInsecure(Boolean allowInsecure) {
        this.allowInsecure = allowInsecure;
        return this;
    }

    public List<IpSecurityRestrictionRule> ipSecurityRestrictions() {
        return this.ipSecurityRestrictions;
    }

    public Ingress withIpSecurityRestrictions(List<IpSecurityRestrictionRule> ipSecurityRestrictions) {
        this.ipSecurityRestrictions = ipSecurityRestrictions;
        return this;
    }

    public IngressStickySessions stickySessions() {
        return this.stickySessions;
    }

    public Ingress withStickySessions(IngressStickySessions stickySessions) {
        this.stickySessions = stickySessions;
        return this;
    }

    public IngressClientCertificateMode clientCertificateMode() {
        return this.clientCertificateMode;
    }

    public Ingress withClientCertificateMode(IngressClientCertificateMode clientCertificateMode) {
        this.clientCertificateMode = clientCertificateMode;
        return this;
    }

    public CorsPolicy corsPolicy() {
        return this.corsPolicy;
    }

    public Ingress withCorsPolicy(CorsPolicy corsPolicy) {
        this.corsPolicy = corsPolicy;
        return this;
    }

    public List<IngressPortMapping> additionalPortMappings() {
        return this.additionalPortMappings;
    }

    public Ingress withAdditionalPortMappings(List<IngressPortMapping> additionalPortMappings) {
        this.additionalPortMappings = additionalPortMappings;
        return this;
    }

    public void validate() {
        if (this.traffic() != null) {
            this.traffic().forEach(e -> e.validate());
        }
        if (this.customDomains() != null) {
            this.customDomains().forEach(e -> e.validate());
        }
        if (this.ipSecurityRestrictions() != null) {
            this.ipSecurityRestrictions().forEach(e -> e.validate());
        }
        if (this.stickySessions() != null) {
            this.stickySessions().validate();
        }
        if (this.corsPolicy() != null) {
            this.corsPolicy().validate();
        }
        if (this.additionalPortMappings() != null) {
            this.additionalPortMappings().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("external", this.external);
        jsonWriter.writeNumberField("targetPort", (Number)this.targetPort);
        jsonWriter.writeNumberField("exposedPort", (Number)this.exposedPort);
        jsonWriter.writeStringField("transport", this.transport == null ? null : this.transport.toString());
        jsonWriter.writeArrayField("traffic", this.traffic, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("customDomains", this.customDomains, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("allowInsecure", this.allowInsecure);
        jsonWriter.writeArrayField("ipSecurityRestrictions", this.ipSecurityRestrictions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("stickySessions", (JsonSerializable)this.stickySessions);
        jsonWriter.writeStringField("clientCertificateMode", this.clientCertificateMode == null ? null : this.clientCertificateMode.toString());
        jsonWriter.writeJsonField("corsPolicy", (JsonSerializable)this.corsPolicy);
        jsonWriter.writeArrayField("additionalPortMappings", this.additionalPortMappings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static Ingress fromJson(JsonReader jsonReader) throws IOException {
        return (Ingress)jsonReader.readObject(reader -> {
            Ingress deserializedIngress = new Ingress();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("fqdn".equals(fieldName)) {
                    deserializedIngress.fqdn = reader.getString();
                    continue;
                }
                if ("external".equals(fieldName)) {
                    deserializedIngress.external = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("targetPort".equals(fieldName)) {
                    deserializedIngress.targetPort = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("exposedPort".equals(fieldName)) {
                    deserializedIngress.exposedPort = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("transport".equals(fieldName)) {
                    deserializedIngress.transport = IngressTransportMethod.fromString(reader.getString());
                    continue;
                }
                if ("traffic".equals(fieldName)) {
                    List traffic;
                    deserializedIngress.traffic = traffic = reader.readArray(reader1 -> TrafficWeight.fromJson(reader1));
                    continue;
                }
                if ("customDomains".equals(fieldName)) {
                    List customDomains;
                    deserializedIngress.customDomains = customDomains = reader.readArray(reader1 -> CustomDomain.fromJson(reader1));
                    continue;
                }
                if ("allowInsecure".equals(fieldName)) {
                    deserializedIngress.allowInsecure = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("ipSecurityRestrictions".equals(fieldName)) {
                    List ipSecurityRestrictions;
                    deserializedIngress.ipSecurityRestrictions = ipSecurityRestrictions = reader.readArray(reader1 -> IpSecurityRestrictionRule.fromJson(reader1));
                    continue;
                }
                if ("stickySessions".equals(fieldName)) {
                    deserializedIngress.stickySessions = IngressStickySessions.fromJson(reader);
                    continue;
                }
                if ("clientCertificateMode".equals(fieldName)) {
                    deserializedIngress.clientCertificateMode = IngressClientCertificateMode.fromString(reader.getString());
                    continue;
                }
                if ("corsPolicy".equals(fieldName)) {
                    deserializedIngress.corsPolicy = CorsPolicy.fromJson(reader);
                    continue;
                }
                if ("additionalPortMappings".equals(fieldName)) {
                    List additionalPortMappings;
                    deserializedIngress.additionalPortMappings = additionalPortMappings = reader.readArray(reader1 -> IngressPortMapping.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIngress;
        });
    }
}

