/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.AllowedAudiencesValidation;
import com.azure.resourcemanager.appcontainers.models.ClientRegistration;
import com.azure.resourcemanager.appcontainers.models.LoginScopes;
import java.io.IOException;

public final class Google
implements JsonSerializable<Google> {
    private Boolean enabled;
    private ClientRegistration registration;
    private LoginScopes login;
    private AllowedAudiencesValidation validation;

    public Boolean enabled() {
        return this.enabled;
    }

    public Google withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public ClientRegistration registration() {
        return this.registration;
    }

    public Google withRegistration(ClientRegistration registration) {
        this.registration = registration;
        return this;
    }

    public LoginScopes login() {
        return this.login;
    }

    public Google withLogin(LoginScopes login) {
        this.login = login;
        return this;
    }

    public AllowedAudiencesValidation validation() {
        return this.validation;
    }

    public Google withValidation(AllowedAudiencesValidation validation) {
        this.validation = validation;
        return this;
    }

    public void validate() {
        if (this.registration() != null) {
            this.registration().validate();
        }
        if (this.login() != null) {
            this.login().validate();
        }
        if (this.validation() != null) {
            this.validation().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeJsonField("registration", (JsonSerializable)this.registration);
        jsonWriter.writeJsonField("login", (JsonSerializable)this.login);
        jsonWriter.writeJsonField("validation", (JsonSerializable)this.validation);
        return jsonWriter.writeEndObject();
    }

    public static Google fromJson(JsonReader jsonReader) throws IOException {
        return (Google)jsonReader.readObject(reader -> {
            Google deserializedGoogle = new Google();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedGoogle.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("registration".equals(fieldName)) {
                    deserializedGoogle.registration = ClientRegistration.fromJson(reader);
                    continue;
                }
                if ("login".equals(fieldName)) {
                    deserializedGoogle.login = LoginScopes.fromJson(reader);
                    continue;
                }
                if ("validation".equals(fieldName)) {
                    deserializedGoogle.validation = AllowedAudiencesValidation.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGoogle;
        });
    }
}

