/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.DiagnosticDataTableResponseObject;
import com.azure.resourcemanager.appcontainers.models.DiagnosticRendering;
import java.io.IOException;

public final class DiagnosticsDataApiResponse
implements JsonSerializable<DiagnosticsDataApiResponse> {
    private DiagnosticDataTableResponseObject table;
    private DiagnosticRendering renderingProperties;

    public DiagnosticDataTableResponseObject table() {
        return this.table;
    }

    public DiagnosticsDataApiResponse withTable(DiagnosticDataTableResponseObject table) {
        this.table = table;
        return this;
    }

    public DiagnosticRendering renderingProperties() {
        return this.renderingProperties;
    }

    public DiagnosticsDataApiResponse withRenderingProperties(DiagnosticRendering renderingProperties) {
        this.renderingProperties = renderingProperties;
        return this;
    }

    public void validate() {
        if (this.table() != null) {
            this.table().validate();
        }
        if (this.renderingProperties() != null) {
            this.renderingProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("table", (JsonSerializable)this.table);
        jsonWriter.writeJsonField("renderingProperties", (JsonSerializable)this.renderingProperties);
        return jsonWriter.writeEndObject();
    }

    public static DiagnosticsDataApiResponse fromJson(JsonReader jsonReader) throws IOException {
        return (DiagnosticsDataApiResponse)jsonReader.readObject(reader -> {
            DiagnosticsDataApiResponse deserializedDiagnosticsDataApiResponse = new DiagnosticsDataApiResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("table".equals(fieldName)) {
                    deserializedDiagnosticsDataApiResponse.table = DiagnosticDataTableResponseObject.fromJson(reader);
                    continue;
                }
                if ("renderingProperties".equals(fieldName)) {
                    deserializedDiagnosticsDataApiResponse.renderingProperties = DiagnosticRendering.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiagnosticsDataApiResponse;
        });
    }
}

