/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.AllowedPrincipals;
import java.io.IOException;
import java.util.List;

public final class DefaultAuthorizationPolicy
implements JsonSerializable<DefaultAuthorizationPolicy> {
    private AllowedPrincipals allowedPrincipals;
    private List<String> allowedApplications;

    public AllowedPrincipals allowedPrincipals() {
        return this.allowedPrincipals;
    }

    public DefaultAuthorizationPolicy withAllowedPrincipals(AllowedPrincipals allowedPrincipals) {
        this.allowedPrincipals = allowedPrincipals;
        return this;
    }

    public List<String> allowedApplications() {
        return this.allowedApplications;
    }

    public DefaultAuthorizationPolicy withAllowedApplications(List<String> allowedApplications) {
        this.allowedApplications = allowedApplications;
        return this;
    }

    public void validate() {
        if (this.allowedPrincipals() != null) {
            this.allowedPrincipals().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("allowedPrincipals", (JsonSerializable)this.allowedPrincipals);
        jsonWriter.writeArrayField("allowedApplications", this.allowedApplications, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static DefaultAuthorizationPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (DefaultAuthorizationPolicy)jsonReader.readObject(reader -> {
            DefaultAuthorizationPolicy deserializedDefaultAuthorizationPolicy = new DefaultAuthorizationPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("allowedPrincipals".equals(fieldName)) {
                    deserializedDefaultAuthorizationPolicy.allowedPrincipals = AllowedPrincipals.fromJson(reader);
                    continue;
                }
                if ("allowedApplications".equals(fieldName)) {
                    List allowedApplications;
                    deserializedDefaultAuthorizationPolicy.allowedApplications = allowedApplications = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDefaultAuthorizationPolicy;
        });
    }
}

