/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.SessionContainer;
import com.azure.resourcemanager.appcontainers.models.SessionIngress;
import com.azure.resourcemanager.appcontainers.models.SessionRegistryCredentials;
import java.io.IOException;
import java.util.List;

public final class CustomContainerTemplate
implements JsonSerializable<CustomContainerTemplate> {
    private SessionRegistryCredentials registryCredentials;
    private List<SessionContainer> containers;
    private SessionIngress ingress;

    public SessionRegistryCredentials registryCredentials() {
        return this.registryCredentials;
    }

    public CustomContainerTemplate withRegistryCredentials(SessionRegistryCredentials registryCredentials) {
        this.registryCredentials = registryCredentials;
        return this;
    }

    public List<SessionContainer> containers() {
        return this.containers;
    }

    public CustomContainerTemplate withContainers(List<SessionContainer> containers) {
        this.containers = containers;
        return this;
    }

    public SessionIngress ingress() {
        return this.ingress;
    }

    public CustomContainerTemplate withIngress(SessionIngress ingress) {
        this.ingress = ingress;
        return this;
    }

    public void validate() {
        if (this.registryCredentials() != null) {
            this.registryCredentials().validate();
        }
        if (this.containers() != null) {
            this.containers().forEach(e -> e.validate());
        }
        if (this.ingress() != null) {
            this.ingress().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("registryCredentials", (JsonSerializable)this.registryCredentials);
        jsonWriter.writeArrayField("containers", this.containers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("ingress", (JsonSerializable)this.ingress);
        return jsonWriter.writeEndObject();
    }

    public static CustomContainerTemplate fromJson(JsonReader jsonReader) throws IOException {
        return (CustomContainerTemplate)jsonReader.readObject(reader -> {
            CustomContainerTemplate deserializedCustomContainerTemplate = new CustomContainerTemplate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("registryCredentials".equals(fieldName)) {
                    deserializedCustomContainerTemplate.registryCredentials = SessionRegistryCredentials.fromJson(reader);
                    continue;
                }
                if ("containers".equals(fieldName)) {
                    List containers;
                    deserializedCustomContainerTemplate.containers = containers = reader.readArray(reader1 -> SessionContainer.fromJson(reader1));
                    continue;
                }
                if ("ingress".equals(fieldName)) {
                    deserializedCustomContainerTemplate.ingress = SessionIngress.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomContainerTemplate;
        });
    }
}

