/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.ConnectedEnvironmentInner;
import com.azure.resourcemanager.appcontainers.models.CheckNameAvailabilityRequest;
import com.azure.resourcemanager.appcontainers.models.CheckNameAvailabilityResponse;
import com.azure.resourcemanager.appcontainers.models.ConnectedEnvironmentProvisioningState;
import com.azure.resourcemanager.appcontainers.models.CustomDomainConfiguration;
import com.azure.resourcemanager.appcontainers.models.ExtendedLocation;
import java.util.Map;

public interface ConnectedEnvironment {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public ExtendedLocation extendedLocation();

    public SystemData systemData();

    public ConnectedEnvironmentProvisioningState provisioningState();

    public String deploymentErrors();

    public String defaultDomain();

    public String staticIp();

    public String daprAIConnectionString();

    public CustomDomainConfiguration customDomainConfiguration();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public ConnectedEnvironmentInner innerModel();

    public Update update();

    public ConnectedEnvironment refresh();

    public ConnectedEnvironment refresh(Context var1);

    public Response<CheckNameAvailabilityResponse> checkNameAvailabilityWithResponse(CheckNameAvailabilityRequest var1, Context var2);

    public CheckNameAvailabilityResponse checkNameAvailability(CheckNameAvailabilityRequest var1);

    public static interface UpdateStages {

        public static interface WithCustomDomainConfiguration {
            public Update withCustomDomainConfiguration(CustomDomainConfiguration var1);
        }

        public static interface WithDaprAIConnectionString {
            public Update withDaprAIConnectionString(String var1);
        }

        public static interface WithStaticIp {
            public Update withStaticIp(String var1);
        }

        public static interface WithExtendedLocation {
            public Update withExtendedLocation(ExtendedLocation var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithExtendedLocation,
    UpdateStages.WithStaticIp,
    UpdateStages.WithDaprAIConnectionString,
    UpdateStages.WithCustomDomainConfiguration {
        public ConnectedEnvironment apply();

        public ConnectedEnvironment apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithCustomDomainConfiguration {
            public WithCreate withCustomDomainConfiguration(CustomDomainConfiguration var1);
        }

        public static interface WithDaprAIConnectionString {
            public WithCreate withDaprAIConnectionString(String var1);
        }

        public static interface WithStaticIp {
            public WithCreate withStaticIp(String var1);
        }

        public static interface WithExtendedLocation {
            public WithCreate withExtendedLocation(ExtendedLocation var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithExtendedLocation,
        WithStaticIp,
        WithDaprAIConnectionString,
        WithCustomDomainConfiguration {
            public ConnectedEnvironment create();

            public ConnectedEnvironment create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

