/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.ManagedEnvironmentUsagesClient;
import com.azure.resourcemanager.appcontainers.fluent.models.UsageInner;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.implementation.UsageImpl;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironmentUsages;
import com.azure.resourcemanager.appcontainers.models.Usage;

public final class ManagedEnvironmentUsagesImpl
implements ManagedEnvironmentUsages {
    private static final ClientLogger LOGGER = new ClientLogger(ManagedEnvironmentUsagesImpl.class);
    private final ManagedEnvironmentUsagesClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public ManagedEnvironmentUsagesImpl(ManagedEnvironmentUsagesClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Usage> list(String resourceGroupName, String environmentName) {
        PagedIterable<UsageInner> inner = this.serviceClient().list(resourceGroupName, environmentName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new UsageImpl((UsageInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<Usage> list(String resourceGroupName, String environmentName, Context context) {
        PagedIterable<UsageInner> inner = this.serviceClient().list(resourceGroupName, environmentName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new UsageImpl((UsageInner)inner1, this.manager()));
    }

    private ManagedEnvironmentUsagesClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}

