/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsRevisionsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.RevisionInner;
import com.azure.resourcemanager.appcontainers.implementation.ContainerAppsApiClientImpl;
import com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException;
import com.azure.resourcemanager.appcontainers.models.RevisionCollection;
import reactor.core.publisher.Mono;

public final class ContainerAppsRevisionsClientImpl
implements ContainerAppsRevisionsClient {
    private final ContainerAppsRevisionsService service;
    private final ContainerAppsApiClientImpl client;

    ContainerAppsRevisionsClientImpl(ContainerAppsApiClientImpl client) {
        this.service = (ContainerAppsRevisionsService)RestProxy.create(ContainerAppsRevisionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RevisionInner>> listRevisionsSinglePageAsync(String resourceGroupName, String containerAppName, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listRevisions(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, this.client.getApiVersion(), filter, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RevisionCollection)res.getValue()).value(), ((RevisionCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RevisionInner>> listRevisionsSinglePageAsync(String resourceGroupName, String containerAppName, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listRevisions(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, this.client.getApiVersion(), filter, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RevisionCollection)res.getValue()).value(), ((RevisionCollection)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RevisionInner> listRevisionsAsync(String resourceGroupName, String containerAppName, String filter) {
        return new PagedFlux(() -> this.listRevisionsSinglePageAsync(resourceGroupName, containerAppName, filter), nextLink -> this.listRevisionsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RevisionInner> listRevisionsAsync(String resourceGroupName, String containerAppName) {
        String filter = null;
        return new PagedFlux(() -> this.listRevisionsSinglePageAsync(resourceGroupName, containerAppName, filter), nextLink -> this.listRevisionsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RevisionInner> listRevisionsAsync(String resourceGroupName, String containerAppName, String filter, Context context) {
        return new PagedFlux(() -> this.listRevisionsSinglePageAsync(resourceGroupName, containerAppName, filter, context), nextLink -> this.listRevisionsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RevisionInner> listRevisions(String resourceGroupName, String containerAppName) {
        String filter = null;
        return new PagedIterable(this.listRevisionsAsync(resourceGroupName, containerAppName, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RevisionInner> listRevisions(String resourceGroupName, String containerAppName, String filter, Context context) {
        return new PagedIterable(this.listRevisionsAsync(resourceGroupName, containerAppName, filter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RevisionInner>> getRevisionWithResponseAsync(String resourceGroupName, String containerAppName, String revisionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (revisionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter revisionName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getRevision(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, revisionName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RevisionInner>> getRevisionWithResponseAsync(String resourceGroupName, String containerAppName, String revisionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (revisionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter revisionName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getRevision(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, revisionName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RevisionInner> getRevisionAsync(String resourceGroupName, String containerAppName, String revisionName) {
        return this.getRevisionWithResponseAsync(resourceGroupName, containerAppName, revisionName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RevisionInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RevisionInner> getRevisionWithResponse(String resourceGroupName, String containerAppName, String revisionName, Context context) {
        return (Response)this.getRevisionWithResponseAsync(resourceGroupName, containerAppName, revisionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RevisionInner getRevision(String resourceGroupName, String containerAppName, String revisionName) {
        return (RevisionInner)((Object)this.getRevisionWithResponse(resourceGroupName, containerAppName, revisionName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> activateRevisionWithResponseAsync(String resourceGroupName, String containerAppName, String revisionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (revisionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter revisionName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.activateRevision(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, revisionName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> activateRevisionWithResponseAsync(String resourceGroupName, String containerAppName, String revisionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (revisionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter revisionName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.activateRevision(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, revisionName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> activateRevisionAsync(String resourceGroupName, String containerAppName, String revisionName) {
        return this.activateRevisionWithResponseAsync(resourceGroupName, containerAppName, revisionName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> activateRevisionWithResponse(String resourceGroupName, String containerAppName, String revisionName, Context context) {
        return (Response)this.activateRevisionWithResponseAsync(resourceGroupName, containerAppName, revisionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void activateRevision(String resourceGroupName, String containerAppName, String revisionName) {
        this.activateRevisionWithResponse(resourceGroupName, containerAppName, revisionName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deactivateRevisionWithResponseAsync(String resourceGroupName, String containerAppName, String revisionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (revisionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter revisionName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deactivateRevision(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, revisionName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deactivateRevisionWithResponseAsync(String resourceGroupName, String containerAppName, String revisionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (revisionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter revisionName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deactivateRevision(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, revisionName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deactivateRevisionAsync(String resourceGroupName, String containerAppName, String revisionName) {
        return this.deactivateRevisionWithResponseAsync(resourceGroupName, containerAppName, revisionName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deactivateRevisionWithResponse(String resourceGroupName, String containerAppName, String revisionName, Context context) {
        return (Response)this.deactivateRevisionWithResponseAsync(resourceGroupName, containerAppName, revisionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deactivateRevision(String resourceGroupName, String containerAppName, String revisionName) {
        this.deactivateRevisionWithResponse(resourceGroupName, containerAppName, revisionName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> restartRevisionWithResponseAsync(String resourceGroupName, String containerAppName, String revisionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (revisionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter revisionName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.restartRevision(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, revisionName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> restartRevisionWithResponseAsync(String resourceGroupName, String containerAppName, String revisionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (revisionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter revisionName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.restartRevision(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, containerAppName, revisionName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> restartRevisionAsync(String resourceGroupName, String containerAppName, String revisionName) {
        return this.restartRevisionWithResponseAsync(resourceGroupName, containerAppName, revisionName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> restartRevisionWithResponse(String resourceGroupName, String containerAppName, String revisionName, Context context) {
        return (Response)this.restartRevisionWithResponseAsync(resourceGroupName, containerAppName, revisionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void restartRevision(String resourceGroupName, String containerAppName, String revisionName) {
        this.restartRevisionWithResponse(resourceGroupName, containerAppName, revisionName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RevisionInner>> listRevisionsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listRevisionsNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RevisionCollection)res.getValue()).value(), ((RevisionCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RevisionInner>> listRevisionsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listRevisionsNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RevisionCollection)res.getValue()).value(), ((RevisionCollection)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ContainerAppsApiClie")
    public static interface ContainerAppsRevisionsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/containerApps/{containerAppName}/revisions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<RevisionCollection>> listRevisions(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="containerAppName") String var4, @QueryParam(value="api-version") String var5, @QueryParam(value="$filter") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/containerApps/{containerAppName}/revisions/{revisionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<RevisionInner>> getRevision(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="containerAppName") String var4, @PathParam(value="revisionName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/containerApps/{containerAppName}/revisions/{revisionName}/activate")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> activateRevision(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="containerAppName") String var4, @PathParam(value="revisionName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/containerApps/{containerAppName}/revisions/{revisionName}/deactivate")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> deactivateRevision(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="containerAppName") String var4, @PathParam(value="revisionName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/containerApps/{containerAppName}/revisions/{revisionName}/restart")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> restartRevision(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="containerAppName") String var4, @PathParam(value="revisionName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<RevisionCollection>> listRevisionsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

