/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.CertificatesClient;
import com.azure.resourcemanager.appcontainers.fluent.models.CertificateInner;
import com.azure.resourcemanager.appcontainers.implementation.CertificateImpl;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.models.Certificate;
import com.azure.resourcemanager.appcontainers.models.CertificatePatch;
import com.azure.resourcemanager.appcontainers.models.Certificates;

public final class CertificatesImpl
implements Certificates {
    private static final ClientLogger LOGGER = new ClientLogger(CertificatesImpl.class);
    private final CertificatesClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public CertificatesImpl(CertificatesClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Certificate> list(String resourceGroupName, String environmentName) {
        PagedIterable<CertificateInner> inner = this.serviceClient().list(resourceGroupName, environmentName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CertificateImpl((CertificateInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Certificate> list(String resourceGroupName, String environmentName, Context context) {
        PagedIterable<CertificateInner> inner = this.serviceClient().list(resourceGroupName, environmentName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CertificateImpl((CertificateInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Certificate> getWithResponse(String resourceGroupName, String environmentName, String certificateName, Context context) {
        Response<CertificateInner> inner = this.serviceClient().getWithResponse(resourceGroupName, environmentName, certificateName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CertificateImpl((CertificateInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Certificate get(String resourceGroupName, String environmentName, String certificateName) {
        CertificateInner inner = this.serviceClient().get(resourceGroupName, environmentName, certificateName);
        if (inner != null) {
            return new CertificateImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Certificate> createOrUpdateWithResponse(String resourceGroupName, String environmentName, String certificateName, CertificateInner certificateEnvelope, Context context) {
        Response<CertificateInner> inner = this.serviceClient().createOrUpdateWithResponse(resourceGroupName, environmentName, certificateName, certificateEnvelope, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CertificateImpl((CertificateInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Certificate createOrUpdate(String resourceGroupName, String environmentName, String certificateName) {
        CertificateInner inner = this.serviceClient().createOrUpdate(resourceGroupName, environmentName, certificateName);
        if (inner != null) {
            return new CertificateImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String environmentName, String certificateName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, environmentName, certificateName, context);
    }

    @Override
    public void delete(String resourceGroupName, String environmentName, String certificateName) {
        this.serviceClient().delete(resourceGroupName, environmentName, certificateName);
    }

    @Override
    public Response<Certificate> updateWithResponse(String resourceGroupName, String environmentName, String certificateName, CertificatePatch certificateEnvelope, Context context) {
        Response<CertificateInner> inner = this.serviceClient().updateWithResponse(resourceGroupName, environmentName, certificateName, certificateEnvelope, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CertificateImpl((CertificateInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Certificate update(String resourceGroupName, String environmentName, String certificateName, CertificatePatch certificateEnvelope) {
        CertificateInner inner = this.serviceClient().update(resourceGroupName, environmentName, certificateName, certificateEnvelope);
        if (inner != null) {
            return new CertificateImpl(inner, this.manager());
        }
        return null;
    }

    private CertificatesClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}

