/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.GithubActionConfiguration;
import com.azure.resourcemanager.appcontainers.models.SourceControlOperationState;
import java.io.IOException;

public final class SourceControlProperties
implements JsonSerializable<SourceControlProperties> {
    private SourceControlOperationState operationState;
    private String repoUrl;
    private String branch;
    private GithubActionConfiguration githubActionConfiguration;

    public SourceControlOperationState operationState() {
        return this.operationState;
    }

    public String repoUrl() {
        return this.repoUrl;
    }

    public SourceControlProperties withRepoUrl(String repoUrl) {
        this.repoUrl = repoUrl;
        return this;
    }

    public String branch() {
        return this.branch;
    }

    public SourceControlProperties withBranch(String branch) {
        this.branch = branch;
        return this;
    }

    public GithubActionConfiguration githubActionConfiguration() {
        return this.githubActionConfiguration;
    }

    public SourceControlProperties withGithubActionConfiguration(GithubActionConfiguration githubActionConfiguration) {
        this.githubActionConfiguration = githubActionConfiguration;
        return this;
    }

    public void validate() {
        if (this.githubActionConfiguration() != null) {
            this.githubActionConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("repoUrl", this.repoUrl);
        jsonWriter.writeStringField("branch", this.branch);
        jsonWriter.writeJsonField("githubActionConfiguration", (JsonSerializable)this.githubActionConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static SourceControlProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SourceControlProperties)jsonReader.readObject(reader -> {
            SourceControlProperties deserializedSourceControlProperties = new SourceControlProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operationState".equals(fieldName)) {
                    deserializedSourceControlProperties.operationState = SourceControlOperationState.fromString(reader.getString());
                    continue;
                }
                if ("repoUrl".equals(fieldName)) {
                    deserializedSourceControlProperties.repoUrl = reader.getString();
                    continue;
                }
                if ("branch".equals(fieldName)) {
                    deserializedSourceControlProperties.branch = reader.getString();
                    continue;
                }
                if ("githubActionConfiguration".equals(fieldName)) {
                    deserializedSourceControlProperties.githubActionConfiguration = GithubActionConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSourceControlProperties;
        });
    }
}

