/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.JobConfiguration;
import com.azure.resourcemanager.appcontainers.models.JobProvisioningState;
import com.azure.resourcemanager.appcontainers.models.JobTemplate;
import java.io.IOException;
import java.util.List;

public final class JobProperties
implements JsonSerializable<JobProperties> {
    private JobProvisioningState provisioningState;
    private String environmentId;
    private String workloadProfileName;
    private JobConfiguration configuration;
    private JobTemplate template;
    private List<String> outboundIpAddresses;
    private String eventStreamEndpoint;

    public JobProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public JobProperties withEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
        return this;
    }

    public String workloadProfileName() {
        return this.workloadProfileName;
    }

    public JobProperties withWorkloadProfileName(String workloadProfileName) {
        this.workloadProfileName = workloadProfileName;
        return this;
    }

    public JobConfiguration configuration() {
        return this.configuration;
    }

    public JobProperties withConfiguration(JobConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    public JobTemplate template() {
        return this.template;
    }

    public JobProperties withTemplate(JobTemplate template) {
        this.template = template;
        return this;
    }

    public List<String> outboundIpAddresses() {
        return this.outboundIpAddresses;
    }

    public String eventStreamEndpoint() {
        return this.eventStreamEndpoint;
    }

    public void validate() {
        if (this.configuration() != null) {
            this.configuration().validate();
        }
        if (this.template() != null) {
            this.template().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("environmentId", this.environmentId);
        jsonWriter.writeStringField("workloadProfileName", this.workloadProfileName);
        jsonWriter.writeJsonField("configuration", (JsonSerializable)this.configuration);
        jsonWriter.writeJsonField("template", (JsonSerializable)this.template);
        return jsonWriter.writeEndObject();
    }

    public static JobProperties fromJson(JsonReader jsonReader) throws IOException {
        return (JobProperties)jsonReader.readObject(reader -> {
            JobProperties deserializedJobProperties = new JobProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedJobProperties.provisioningState = JobProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("environmentId".equals(fieldName)) {
                    deserializedJobProperties.environmentId = reader.getString();
                    continue;
                }
                if ("workloadProfileName".equals(fieldName)) {
                    deserializedJobProperties.workloadProfileName = reader.getString();
                    continue;
                }
                if ("configuration".equals(fieldName)) {
                    deserializedJobProperties.configuration = JobConfiguration.fromJson(reader);
                    continue;
                }
                if ("template".equals(fieldName)) {
                    deserializedJobProperties.template = JobTemplate.fromJson(reader);
                    continue;
                }
                if ("outboundIpAddresses".equals(fieldName)) {
                    List outboundIpAddresses;
                    deserializedJobProperties.outboundIpAddresses = outboundIpAddresses = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("eventStreamEndpoint".equals(fieldName)) {
                    deserializedJobProperties.eventStreamEndpoint = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobProperties;
        });
    }
}

