/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.DaprSecret;
import java.io.IOException;
import java.util.List;

public final class DaprSecretsCollectionInner
implements JsonSerializable<DaprSecretsCollectionInner> {
    private List<DaprSecret> value;
    private static final ClientLogger LOGGER = new ClientLogger(DaprSecretsCollectionInner.class);

    public List<DaprSecret> value() {
        return this.value;
    }

    public DaprSecretsCollectionInner withValue(List<DaprSecret> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model DaprSecretsCollectionInner"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DaprSecretsCollectionInner fromJson(JsonReader jsonReader) throws IOException {
        return (DaprSecretsCollectionInner)jsonReader.readObject(reader -> {
            DaprSecretsCollectionInner deserializedDaprSecretsCollectionInner = new DaprSecretsCollectionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedDaprSecretsCollectionInner.value = value = reader.readArray(reader1 -> DaprSecret.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDaprSecretsCollectionInner;
        });
    }
}

