/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.DaprComponentProperties;
import com.azure.resourcemanager.appcontainers.models.DaprMetadata;
import com.azure.resourcemanager.appcontainers.models.Secret;
import java.io.IOException;
import java.util.List;

public final class DaprComponentInner
extends ProxyResource {
    private DaprComponentProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private DaprComponentProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String componentType() {
        return this.innerProperties() == null ? null : this.innerProperties().componentType();
    }

    public DaprComponentInner withComponentType(String componentType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DaprComponentProperties();
        }
        this.innerProperties().withComponentType(componentType);
        return this;
    }

    public String version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    public DaprComponentInner withVersion(String version) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DaprComponentProperties();
        }
        this.innerProperties().withVersion(version);
        return this;
    }

    public Boolean ignoreErrors() {
        return this.innerProperties() == null ? null : this.innerProperties().ignoreErrors();
    }

    public DaprComponentInner withIgnoreErrors(Boolean ignoreErrors) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DaprComponentProperties();
        }
        this.innerProperties().withIgnoreErrors(ignoreErrors);
        return this;
    }

    public String initTimeout() {
        return this.innerProperties() == null ? null : this.innerProperties().initTimeout();
    }

    public DaprComponentInner withInitTimeout(String initTimeout) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DaprComponentProperties();
        }
        this.innerProperties().withInitTimeout(initTimeout);
        return this;
    }

    public List<Secret> secrets() {
        return this.innerProperties() == null ? null : this.innerProperties().secrets();
    }

    public DaprComponentInner withSecrets(List<Secret> secrets) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DaprComponentProperties();
        }
        this.innerProperties().withSecrets(secrets);
        return this;
    }

    public String secretStoreComponent() {
        return this.innerProperties() == null ? null : this.innerProperties().secretStoreComponent();
    }

    public DaprComponentInner withSecretStoreComponent(String secretStoreComponent) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DaprComponentProperties();
        }
        this.innerProperties().withSecretStoreComponent(secretStoreComponent);
        return this;
    }

    public List<DaprMetadata> metadata() {
        return this.innerProperties() == null ? null : this.innerProperties().metadata();
    }

    public DaprComponentInner withMetadata(List<DaprMetadata> metadata) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DaprComponentProperties();
        }
        this.innerProperties().withMetadata(metadata);
        return this;
    }

    public List<String> scopes() {
        return this.innerProperties() == null ? null : this.innerProperties().scopes();
    }

    public DaprComponentInner withScopes(List<String> scopes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DaprComponentProperties();
        }
        this.innerProperties().withScopes(scopes);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static DaprComponentInner fromJson(JsonReader jsonReader) throws IOException {
        return (DaprComponentInner)((Object)jsonReader.readObject(reader -> {
            DaprComponentInner deserializedDaprComponentInner = new DaprComponentInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDaprComponentInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDaprComponentInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDaprComponentInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDaprComponentInner.innerProperties = DaprComponentProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedDaprComponentInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDaprComponentInner;
        }));
    }
}

