/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.CustomHostnameAnalysisResultCustomDomainVerificationFailureInfo;
import com.azure.resourcemanager.appcontainers.models.DnsVerificationTestResult;
import java.io.IOException;
import java.util.List;

public final class CustomHostnameAnalysisResultInner
implements JsonSerializable<CustomHostnameAnalysisResultInner> {
    private String hostname;
    private Boolean isHostnameAlreadyVerified;
    private DnsVerificationTestResult customDomainVerificationTest;
    private CustomHostnameAnalysisResultCustomDomainVerificationFailureInfo customDomainVerificationFailureInfo;
    private Boolean hasConflictOnManagedEnvironment;
    private Boolean conflictWithEnvironmentCustomDomain;
    private String conflictingContainerAppResourceId;
    private List<String> cNameRecords;
    private List<String> txtRecords;
    private List<String> aRecords;
    private List<String> alternateCNameRecords;
    private List<String> alternateTxtRecords;

    public String hostname() {
        return this.hostname;
    }

    public Boolean isHostnameAlreadyVerified() {
        return this.isHostnameAlreadyVerified;
    }

    public DnsVerificationTestResult customDomainVerificationTest() {
        return this.customDomainVerificationTest;
    }

    public CustomHostnameAnalysisResultCustomDomainVerificationFailureInfo customDomainVerificationFailureInfo() {
        return this.customDomainVerificationFailureInfo;
    }

    public Boolean hasConflictOnManagedEnvironment() {
        return this.hasConflictOnManagedEnvironment;
    }

    public Boolean conflictWithEnvironmentCustomDomain() {
        return this.conflictWithEnvironmentCustomDomain;
    }

    public String conflictingContainerAppResourceId() {
        return this.conflictingContainerAppResourceId;
    }

    public List<String> cNameRecords() {
        return this.cNameRecords;
    }

    public CustomHostnameAnalysisResultInner withCNameRecords(List<String> cNameRecords) {
        this.cNameRecords = cNameRecords;
        return this;
    }

    public List<String> txtRecords() {
        return this.txtRecords;
    }

    public CustomHostnameAnalysisResultInner withTxtRecords(List<String> txtRecords) {
        this.txtRecords = txtRecords;
        return this;
    }

    public List<String> aRecords() {
        return this.aRecords;
    }

    public CustomHostnameAnalysisResultInner withARecords(List<String> aRecords) {
        this.aRecords = aRecords;
        return this;
    }

    public List<String> alternateCNameRecords() {
        return this.alternateCNameRecords;
    }

    public CustomHostnameAnalysisResultInner withAlternateCNameRecords(List<String> alternateCNameRecords) {
        this.alternateCNameRecords = alternateCNameRecords;
        return this;
    }

    public List<String> alternateTxtRecords() {
        return this.alternateTxtRecords;
    }

    public CustomHostnameAnalysisResultInner withAlternateTxtRecords(List<String> alternateTxtRecords) {
        this.alternateTxtRecords = alternateTxtRecords;
        return this;
    }

    public void validate() {
        if (this.customDomainVerificationFailureInfo() != null) {
            this.customDomainVerificationFailureInfo().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("cNameRecords", this.cNameRecords, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("txtRecords", this.txtRecords, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("aRecords", this.aRecords, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("alternateCNameRecords", this.alternateCNameRecords, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("alternateTxtRecords", this.alternateTxtRecords, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static CustomHostnameAnalysisResultInner fromJson(JsonReader jsonReader) throws IOException {
        return (CustomHostnameAnalysisResultInner)jsonReader.readObject(reader -> {
            CustomHostnameAnalysisResultInner deserializedCustomHostnameAnalysisResultInner = new CustomHostnameAnalysisResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("hostName".equals(fieldName)) {
                    deserializedCustomHostnameAnalysisResultInner.hostname = reader.getString();
                    continue;
                }
                if ("isHostnameAlreadyVerified".equals(fieldName)) {
                    deserializedCustomHostnameAnalysisResultInner.isHostnameAlreadyVerified = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("customDomainVerificationTest".equals(fieldName)) {
                    deserializedCustomHostnameAnalysisResultInner.customDomainVerificationTest = DnsVerificationTestResult.fromString(reader.getString());
                    continue;
                }
                if ("customDomainVerificationFailureInfo".equals(fieldName)) {
                    deserializedCustomHostnameAnalysisResultInner.customDomainVerificationFailureInfo = CustomHostnameAnalysisResultCustomDomainVerificationFailureInfo.fromJson(reader);
                    continue;
                }
                if ("hasConflictOnManagedEnvironment".equals(fieldName)) {
                    deserializedCustomHostnameAnalysisResultInner.hasConflictOnManagedEnvironment = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("conflictWithEnvironmentCustomDomain".equals(fieldName)) {
                    deserializedCustomHostnameAnalysisResultInner.conflictWithEnvironmentCustomDomain = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("conflictingContainerAppResourceId".equals(fieldName)) {
                    deserializedCustomHostnameAnalysisResultInner.conflictingContainerAppResourceId = reader.getString();
                    continue;
                }
                if ("cNameRecords".equals(fieldName)) {
                    List cNameRecords;
                    deserializedCustomHostnameAnalysisResultInner.cNameRecords = cNameRecords = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("txtRecords".equals(fieldName)) {
                    List txtRecords;
                    deserializedCustomHostnameAnalysisResultInner.txtRecords = txtRecords = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("aRecords".equals(fieldName)) {
                    List aRecords;
                    deserializedCustomHostnameAnalysisResultInner.aRecords = aRecords = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("alternateCNameRecords".equals(fieldName)) {
                    List alternateCNameRecords;
                    deserializedCustomHostnameAnalysisResultInner.alternateCNameRecords = alternateCNameRecords = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("alternateTxtRecords".equals(fieldName)) {
                    List alternateTxtRecords;
                    deserializedCustomHostnameAnalysisResultInner.alternateTxtRecords = alternateTxtRecords = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomHostnameAnalysisResultInner;
        });
    }
}

