/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.implementation.models;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import java.time.OffsetDateTime;

public final class PathsGetPropertiesHeaders {
    private String xMsLeaseStatus;
    private String contentRange;
    private String xMsLeaseState;
    private DateTimeRfc1123 lastModified;
    private String xMsProperties;
    private String xMsEncryptionKeySha256;
    private String contentEncoding;
    private DateTimeRfc1123 xMsCreationTime;
    private String xMsPermissions;
    private String xMsLeaseDuration;
    private Long contentLength;
    private String xMsRequestId;
    private String xMsOwner;
    private String contentType;
    private String xMsGroup;
    private String xMsVersion;
    private String xMsEncryptionContext;
    private String xMsAcl;
    private DateTimeRfc1123 date;
    private String xMsResourceType;
    private DateTimeRfc1123 xMsExpiryTime;
    private String contentMD5;
    private String acceptRanges;
    private Boolean xMsServerEncrypted;
    private String cacheControl;
    private String eTag;
    private String contentDisposition;
    private String contentLanguage;
    private String xMsEncryptionScope;
    private static final HttpHeaderName X_MS_LEASE_STATUS = HttpHeaderName.fromString((String)"x-ms-lease-status");
    private static final HttpHeaderName X_MS_LEASE_STATE = HttpHeaderName.fromString((String)"x-ms-lease-state");
    private static final HttpHeaderName X_MS_PROPERTIES = HttpHeaderName.fromString((String)"x-ms-properties");
    private static final HttpHeaderName X_MS_ENCRYPTION_KEY_SHA256 = HttpHeaderName.fromString((String)"x-ms-encryption-key-sha256");
    private static final HttpHeaderName X_MS_CREATION_TIME = HttpHeaderName.fromString((String)"x-ms-creation-time");
    private static final HttpHeaderName X_MS_PERMISSIONS = HttpHeaderName.fromString((String)"x-ms-permissions");
    private static final HttpHeaderName X_MS_LEASE_DURATION = HttpHeaderName.fromString((String)"x-ms-lease-duration");
    private static final HttpHeaderName X_MS_OWNER = HttpHeaderName.fromString((String)"x-ms-owner");
    private static final HttpHeaderName X_MS_GROUP = HttpHeaderName.fromString((String)"x-ms-group");
    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString((String)"x-ms-version");
    private static final HttpHeaderName X_MS_ENCRYPTION_CONTEXT = HttpHeaderName.fromString((String)"x-ms-encryption-context");
    private static final HttpHeaderName X_MS_ACL = HttpHeaderName.fromString((String)"x-ms-acl");
    private static final HttpHeaderName X_MS_RESOURCE_TYPE = HttpHeaderName.fromString((String)"x-ms-resource-type");
    private static final HttpHeaderName X_MS_EXPIRY_TIME = HttpHeaderName.fromString((String)"x-ms-expiry-time");
    private static final HttpHeaderName X_MS_SERVER_ENCRYPTED = HttpHeaderName.fromString((String)"x-ms-server-encrypted");
    private static final HttpHeaderName X_MS_ENCRYPTION_SCOPE = HttpHeaderName.fromString((String)"x-ms-encryption-scope");

    public PathsGetPropertiesHeaders(HttpHeaders rawHeaders) {
        this.xMsLeaseStatus = rawHeaders.getValue(X_MS_LEASE_STATUS);
        this.contentRange = rawHeaders.getValue(HttpHeaderName.CONTENT_RANGE);
        this.xMsLeaseState = rawHeaders.getValue(X_MS_LEASE_STATE);
        String lastModified = rawHeaders.getValue(HttpHeaderName.LAST_MODIFIED);
        this.lastModified = lastModified != null ? new DateTimeRfc1123(lastModified) : null;
        this.xMsProperties = rawHeaders.getValue(X_MS_PROPERTIES);
        this.xMsEncryptionKeySha256 = rawHeaders.getValue(X_MS_ENCRYPTION_KEY_SHA256);
        this.contentEncoding = rawHeaders.getValue(HttpHeaderName.CONTENT_ENCODING);
        String xMsCreationTime = rawHeaders.getValue(X_MS_CREATION_TIME);
        this.xMsCreationTime = xMsCreationTime != null ? new DateTimeRfc1123(xMsCreationTime) : null;
        this.xMsPermissions = rawHeaders.getValue(X_MS_PERMISSIONS);
        this.xMsLeaseDuration = rawHeaders.getValue(X_MS_LEASE_DURATION);
        String contentLength = rawHeaders.getValue(HttpHeaderName.CONTENT_LENGTH);
        this.contentLength = contentLength != null ? Long.valueOf(Long.parseLong(contentLength)) : null;
        this.xMsRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_REQUEST_ID);
        this.xMsOwner = rawHeaders.getValue(X_MS_OWNER);
        this.contentType = rawHeaders.getValue(HttpHeaderName.CONTENT_TYPE);
        this.xMsGroup = rawHeaders.getValue(X_MS_GROUP);
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        this.xMsEncryptionContext = rawHeaders.getValue(X_MS_ENCRYPTION_CONTEXT);
        this.xMsAcl = rawHeaders.getValue(X_MS_ACL);
        String date = rawHeaders.getValue(HttpHeaderName.DATE);
        this.date = date != null ? new DateTimeRfc1123(date) : null;
        this.xMsResourceType = rawHeaders.getValue(X_MS_RESOURCE_TYPE);
        String xMsExpiryTime = rawHeaders.getValue(X_MS_EXPIRY_TIME);
        this.xMsExpiryTime = xMsExpiryTime != null ? new DateTimeRfc1123(xMsExpiryTime) : null;
        this.contentMD5 = rawHeaders.getValue(HttpHeaderName.CONTENT_MD5);
        this.acceptRanges = rawHeaders.getValue(HttpHeaderName.ACCEPT_RANGES);
        String xMsServerEncrypted = rawHeaders.getValue(X_MS_SERVER_ENCRYPTED);
        this.xMsServerEncrypted = xMsServerEncrypted != null ? Boolean.valueOf(Boolean.parseBoolean(xMsServerEncrypted)) : null;
        this.cacheControl = rawHeaders.getValue(HttpHeaderName.CACHE_CONTROL);
        this.eTag = rawHeaders.getValue(HttpHeaderName.ETAG);
        this.contentDisposition = rawHeaders.getValue(HttpHeaderName.CONTENT_DISPOSITION);
        this.contentLanguage = rawHeaders.getValue(HttpHeaderName.CONTENT_LANGUAGE);
        this.xMsEncryptionScope = rawHeaders.getValue(X_MS_ENCRYPTION_SCOPE);
    }

    public String getXMsLeaseStatus() {
        return this.xMsLeaseStatus;
    }

    public PathsGetPropertiesHeaders setXMsLeaseStatus(String xMsLeaseStatus) {
        this.xMsLeaseStatus = xMsLeaseStatus;
        return this;
    }

    public String getContentRange() {
        return this.contentRange;
    }

    public PathsGetPropertiesHeaders setContentRange(String contentRange) {
        this.contentRange = contentRange;
        return this;
    }

    public String getXMsLeaseState() {
        return this.xMsLeaseState;
    }

    public PathsGetPropertiesHeaders setXMsLeaseState(String xMsLeaseState) {
        this.xMsLeaseState = xMsLeaseState;
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public PathsGetPropertiesHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String getXMsProperties() {
        return this.xMsProperties;
    }

    public PathsGetPropertiesHeaders setXMsProperties(String xMsProperties) {
        this.xMsProperties = xMsProperties;
        return this;
    }

    public String getXMsEncryptionKeySha256() {
        return this.xMsEncryptionKeySha256;
    }

    public PathsGetPropertiesHeaders setXMsEncryptionKeySha256(String xMsEncryptionKeySha256) {
        this.xMsEncryptionKeySha256 = xMsEncryptionKeySha256;
        return this;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public PathsGetPropertiesHeaders setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public OffsetDateTime getXMsCreationTime() {
        if (this.xMsCreationTime == null) {
            return null;
        }
        return this.xMsCreationTime.getDateTime();
    }

    public PathsGetPropertiesHeaders setXMsCreationTime(OffsetDateTime xMsCreationTime) {
        this.xMsCreationTime = xMsCreationTime == null ? null : new DateTimeRfc1123(xMsCreationTime);
        return this;
    }

    public String getXMsPermissions() {
        return this.xMsPermissions;
    }

    public PathsGetPropertiesHeaders setXMsPermissions(String xMsPermissions) {
        this.xMsPermissions = xMsPermissions;
        return this;
    }

    public String getXMsLeaseDuration() {
        return this.xMsLeaseDuration;
    }

    public PathsGetPropertiesHeaders setXMsLeaseDuration(String xMsLeaseDuration) {
        this.xMsLeaseDuration = xMsLeaseDuration;
        return this;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public PathsGetPropertiesHeaders setContentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public PathsGetPropertiesHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public String getXMsOwner() {
        return this.xMsOwner;
    }

    public PathsGetPropertiesHeaders setXMsOwner(String xMsOwner) {
        this.xMsOwner = xMsOwner;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public PathsGetPropertiesHeaders setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getXMsGroup() {
        return this.xMsGroup;
    }

    public PathsGetPropertiesHeaders setXMsGroup(String xMsGroup) {
        this.xMsGroup = xMsGroup;
        return this;
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public PathsGetPropertiesHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public String getXMsEncryptionContext() {
        return this.xMsEncryptionContext;
    }

    public PathsGetPropertiesHeaders setXMsEncryptionContext(String xMsEncryptionContext) {
        this.xMsEncryptionContext = xMsEncryptionContext;
        return this;
    }

    public String getXMsAcl() {
        return this.xMsAcl;
    }

    public PathsGetPropertiesHeaders setXMsAcl(String xMsAcl) {
        this.xMsAcl = xMsAcl;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public PathsGetPropertiesHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }

    public String getXMsResourceType() {
        return this.xMsResourceType;
    }

    public PathsGetPropertiesHeaders setXMsResourceType(String xMsResourceType) {
        this.xMsResourceType = xMsResourceType;
        return this;
    }

    public OffsetDateTime getXMsExpiryTime() {
        if (this.xMsExpiryTime == null) {
            return null;
        }
        return this.xMsExpiryTime.getDateTime();
    }

    public PathsGetPropertiesHeaders setXMsExpiryTime(OffsetDateTime xMsExpiryTime) {
        this.xMsExpiryTime = xMsExpiryTime == null ? null : new DateTimeRfc1123(xMsExpiryTime);
        return this;
    }

    public String getContentMD5() {
        return this.contentMD5;
    }

    public PathsGetPropertiesHeaders setContentMD5(String contentMD5) {
        this.contentMD5 = contentMD5;
        return this;
    }

    public String getAcceptRanges() {
        return this.acceptRanges;
    }

    public PathsGetPropertiesHeaders setAcceptRanges(String acceptRanges) {
        this.acceptRanges = acceptRanges;
        return this;
    }

    public Boolean isXMsServerEncrypted() {
        return this.xMsServerEncrypted;
    }

    public PathsGetPropertiesHeaders setXMsServerEncrypted(Boolean xMsServerEncrypted) {
        this.xMsServerEncrypted = xMsServerEncrypted;
        return this;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public PathsGetPropertiesHeaders setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public PathsGetPropertiesHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public PathsGetPropertiesHeaders setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public PathsGetPropertiesHeaders setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    public String getXMsEncryptionScope() {
        return this.xMsEncryptionScope;
    }

    public PathsGetPropertiesHeaders setXMsEncryptionScope(String xMsEncryptionScope) {
        this.xMsEncryptionScope = xMsEncryptionScope;
        return this;
    }
}

