/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.implementation.models;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import java.time.OffsetDateTime;

public final class PathsFlushDataHeaders {
    private String xMsVersion;
    private String eTag;
    private DateTimeRfc1123 lastModified;
    private Long contentLength;
    private String xMsEncryptionKeySha256;
    private Boolean xMsLeaseRenewed;
    private String xMsRequestId;
    private Boolean xMsRequestServerEncrypted;
    private DateTimeRfc1123 date;
    private String xMsClientRequestId;
    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString((String)"x-ms-version");
    private static final HttpHeaderName X_MS_ENCRYPTION_KEY_SHA256 = HttpHeaderName.fromString((String)"x-ms-encryption-key-sha256");
    private static final HttpHeaderName X_MS_LEASE_RENEWED = HttpHeaderName.fromString((String)"x-ms-lease-renewed");
    private static final HttpHeaderName X_MS_REQUEST_SERVER_ENCRYPTED = HttpHeaderName.fromString((String)"x-ms-request-server-encrypted");

    public PathsFlushDataHeaders(HttpHeaders rawHeaders) {
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        this.eTag = rawHeaders.getValue(HttpHeaderName.ETAG);
        String lastModified = rawHeaders.getValue(HttpHeaderName.LAST_MODIFIED);
        this.lastModified = lastModified != null ? new DateTimeRfc1123(lastModified) : null;
        String contentLength = rawHeaders.getValue(HttpHeaderName.CONTENT_LENGTH);
        this.contentLength = contentLength != null ? Long.valueOf(Long.parseLong(contentLength)) : null;
        this.xMsEncryptionKeySha256 = rawHeaders.getValue(X_MS_ENCRYPTION_KEY_SHA256);
        String xMsLeaseRenewed = rawHeaders.getValue(X_MS_LEASE_RENEWED);
        this.xMsLeaseRenewed = xMsLeaseRenewed != null ? Boolean.valueOf(Boolean.parseBoolean(xMsLeaseRenewed)) : null;
        this.xMsRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_REQUEST_ID);
        String xMsRequestServerEncrypted = rawHeaders.getValue(X_MS_REQUEST_SERVER_ENCRYPTED);
        this.xMsRequestServerEncrypted = xMsRequestServerEncrypted != null ? Boolean.valueOf(Boolean.parseBoolean(xMsRequestServerEncrypted)) : null;
        String date = rawHeaders.getValue(HttpHeaderName.DATE);
        this.date = date != null ? new DateTimeRfc1123(date) : null;
        this.xMsClientRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_CLIENT_REQUEST_ID);
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public PathsFlushDataHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public PathsFlushDataHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public PathsFlushDataHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public PathsFlushDataHeaders setContentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public String getXMsEncryptionKeySha256() {
        return this.xMsEncryptionKeySha256;
    }

    public PathsFlushDataHeaders setXMsEncryptionKeySha256(String xMsEncryptionKeySha256) {
        this.xMsEncryptionKeySha256 = xMsEncryptionKeySha256;
        return this;
    }

    public Boolean isXMsLeaseRenewed() {
        return this.xMsLeaseRenewed;
    }

    public PathsFlushDataHeaders setXMsLeaseRenewed(Boolean xMsLeaseRenewed) {
        this.xMsLeaseRenewed = xMsLeaseRenewed;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public PathsFlushDataHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public Boolean isXMsRequestServerEncrypted() {
        return this.xMsRequestServerEncrypted;
    }

    public PathsFlushDataHeaders setXMsRequestServerEncrypted(Boolean xMsRequestServerEncrypted) {
        this.xMsRequestServerEncrypted = xMsRequestServerEncrypted;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public PathsFlushDataHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }

    public String getXMsClientRequestId() {
        return this.xMsClientRequestId;
    }

    public PathsFlushDataHeaders setXMsClientRequestId(String xMsClientRequestId) {
        this.xMsClientRequestId = xMsClientRequestId;
        return this;
    }
}

