/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized.cryptography;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

final class WrappedKey
implements JsonSerializable<WrappedKey> {
    private String keyId;
    private byte[] encryptedKey;
    private String algorithm;

    WrappedKey() {
    }

    WrappedKey(String keyId, byte[] encryptedKey, String algorithm) {
        this.keyId = keyId;
        this.encryptedKey = encryptedKey;
        this.algorithm = algorithm;
    }

    String getKeyId() {
        return this.keyId;
    }

    byte[] getEncryptedKey() {
        return this.encryptedKey;
    }

    String getAlgorithm() {
        return this.algorithm;
    }

    WrappedKey setKeyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    WrappedKey setEncryptedKey(byte[] encryptedKey) {
        this.encryptedKey = encryptedKey;
        return this;
    }

    WrappedKey setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeStringField("KeyId", this.keyId).writeBinaryField("EncryptedKey", this.encryptedKey).writeStringField("Algorithm", this.algorithm).writeEndObject();
    }

    public static WrappedKey fromJson(JsonReader jsonReader) throws IOException {
        return (WrappedKey)jsonReader.readObject(reader -> {
            WrappedKey wrappedKey = new WrappedKey();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("KeyId".equals(fieldName)) {
                    wrappedKey.keyId = reader.getString();
                    continue;
                }
                if ("EncryptedKey".equals(fieldName)) {
                    wrappedKey.encryptedKey = reader.getBinary();
                    continue;
                }
                if ("Algorithm".equals(fieldName)) {
                    wrappedKey.algorithm = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return wrappedKey;
        });
    }
}

