/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized.cryptography;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.specialized.cryptography.EncryptionAgent;
import com.azure.storage.blob.specialized.cryptography.EncryptionAlgorithm;
import com.azure.storage.blob.specialized.cryptography.EncryptionData;
import com.azure.storage.blob.specialized.cryptography.Encryptor;
import com.azure.storage.blob.specialized.cryptography.WrappedKey;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class EncryptorV1
extends Encryptor {
    private static final ClientLogger LOGGER = new ClientLogger(EncryptorV1.class);
    private final Cipher cipher = this.getCipher();

    protected EncryptorV1(SecretKey aesKey) throws GeneralSecurityException {
        super(aesKey);
    }

    @Override
    byte[] getKeyToWrap() {
        return this.aesKey.getEncoded();
    }

    @Override
    protected EncryptionData buildEncryptionData(Map<String, String> keyWrappingMetadata, WrappedKey wrappedKey) {
        return super.buildEncryptionData(keyWrappingMetadata, wrappedKey).setEncryptionAgent(new EncryptionAgent("1.0", EncryptionAlgorithm.AES_CBC_256)).setContentEncryptionIV(this.cipher.getIV());
    }

    private Cipher getCipher() throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(1, this.aesKey);
        return cipher;
    }

    @Override
    protected Flux<ByteBuffer> encrypt(Flux<ByteBuffer> plainTextFlux) throws GeneralSecurityException {
        Flux encryptedTextFlux = plainTextFlux.map(plainTextBuffer -> {
            int encryptedBytes;
            int outputSize = this.cipher.getOutputSize(plainTextBuffer.remaining());
            ByteBuffer encryptedTextBuffer = ByteBuffer.allocate(outputSize);
            try {
                encryptedBytes = this.cipher.update((ByteBuffer)plainTextBuffer, encryptedTextBuffer);
            }
            catch (ShortBufferException e) {
                throw LOGGER.logExceptionAsError(Exceptions.propagate((Throwable)e));
            }
            encryptedTextBuffer.position(0);
            encryptedTextBuffer.limit(encryptedBytes);
            return encryptedTextBuffer;
        });
        encryptedTextFlux = Flux.concat((Publisher[])new Publisher[]{encryptedTextFlux, Mono.fromCallable(() -> ByteBuffer.wrap(this.cipher.doFinal()))});
        return encryptedTextFlux;
    }
}

