/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized.cryptography;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.storage.blob.specialized.cryptography.EncryptedRegionInfo;
import com.azure.storage.blob.specialized.cryptography.EncryptionAgent;
import com.azure.storage.blob.specialized.cryptography.EncryptionAlgorithm;
import com.azure.storage.blob.specialized.cryptography.WrappedKey;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

final class EncryptionData
implements JsonSerializable<EncryptionData> {
    private static final ClientLogger LOGGER = new ClientLogger(EncryptionData.class);
    private String encryptionMode;
    private WrappedKey wrappedContentKey;
    private EncryptionAgent encryptionAgent;
    private byte[] contentEncryptionIV;
    private EncryptedRegionInfo encryptedRegionInfo;
    private Map<String, String> keyWrappingMetadata;

    EncryptionData() {
    }

    EncryptionData(String encryptionMode, WrappedKey wrappedContentKey, EncryptionAgent encryptionAgent, byte[] contentEncryptionIV, EncryptedRegionInfo encryptedRegionInfo, Map<String, String> keyWrappingMetadata) {
        this.encryptionMode = encryptionMode;
        this.wrappedContentKey = wrappedContentKey;
        this.encryptionAgent = encryptionAgent;
        this.contentEncryptionIV = contentEncryptionIV;
        this.encryptedRegionInfo = encryptedRegionInfo;
        this.keyWrappingMetadata = keyWrappingMetadata;
    }

    String getEncryptionMode() {
        return this.encryptionMode;
    }

    WrappedKey getWrappedContentKey() {
        return this.wrappedContentKey;
    }

    EncryptionAgent getEncryptionAgent() {
        return this.encryptionAgent;
    }

    byte[] getContentEncryptionIV() {
        return this.contentEncryptionIV;
    }

    EncryptedRegionInfo getEncryptedRegionInfo() {
        return this.encryptedRegionInfo;
    }

    Map<String, String> getKeyWrappingMetadata() {
        return this.keyWrappingMetadata;
    }

    EncryptionData setEncryptionMode(String encryptionMode) {
        this.encryptionMode = encryptionMode;
        return this;
    }

    EncryptionData setWrappedContentKey(WrappedKey wrappedContentKey) {
        this.wrappedContentKey = wrappedContentKey;
        return this;
    }

    EncryptionData setEncryptionAgent(EncryptionAgent encryptionAgent) {
        this.encryptionAgent = encryptionAgent;
        return this;
    }

    EncryptionData setContentEncryptionIV(byte[] contentEncryptionIV) {
        this.contentEncryptionIV = contentEncryptionIV;
        return this;
    }

    EncryptionData setKeyWrappingMetadata(Map<String, String> keyWrappingMetadata) {
        this.keyWrappingMetadata = keyWrappingMetadata;
        return this;
    }

    EncryptionData setEncryptedRegionInfo(EncryptedRegionInfo encryptedRegionInfo) {
        this.encryptedRegionInfo = encryptedRegionInfo;
        return this;
    }

    static EncryptionData getAndValidateEncryptionData(String encryptionDataString, boolean requiresEncryption) {
        EncryptionData encryptionData;
        block16: {
            if (encryptionDataString == null) {
                if (requiresEncryption) {
                    throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'requiresEncryption' set to true but downloaded data is not encrypted."));
                }
                return null;
            }
            JsonReader jsonReader = JsonProviders.createReader((String)encryptionDataString);
            try {
                EncryptionData encryptionData2 = EncryptionData.fromJson(jsonReader);
                String encryptionProtocol = encryptionData2.getEncryptionAgent().getProtocol();
                if (encryptionProtocol.equals("1.0")) {
                    Objects.requireNonNull(encryptionData2.getContentEncryptionIV(), "contentEncryptionIV in encryptionData cannot be null");
                    Objects.requireNonNull(encryptionData2.getWrappedContentKey().getEncryptedKey(), "encryptedKey in encryptionData.wrappedContentKey cannot be null");
                    if (!encryptionData2.getEncryptionAgent().getAlgorithm().equals((Object)EncryptionAlgorithm.AES_CBC_256)) {
                        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Encryption algorithm does not match v1 protocol: " + (Object)((Object)encryptionData2.getEncryptionAgent().getAlgorithm())));
                    }
                } else if (encryptionProtocol.equals("2.0") || encryptionProtocol.equals("2.1")) {
                    Objects.requireNonNull(encryptionData2.getWrappedContentKey().getEncryptedKey(), "encryptedKey in encryptionData.wrappedContentKey cannot be null");
                    if (!encryptionData2.getEncryptionAgent().getAlgorithm().equals((Object)EncryptionAlgorithm.AES_GCM_256)) {
                        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Encryption algorithm does not match v2 protocol: " + (Object)((Object)encryptionData2.getEncryptionAgent().getAlgorithm())));
                    }
                } else {
                    throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format(Locale.ROOT, "Invalid Encryption Agent. This version of the client library does not understand the Encryption Agent set on the blob message: %s", encryptionDataString)));
                }
                encryptionData = encryptionData2;
                if (jsonReader == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw LOGGER.logExceptionAsError(new RuntimeException(e));
                }
            }
            jsonReader.close();
        }
        return encryptionData;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeStringField("EncryptionMode", this.encryptionMode).writeJsonField("WrappedContentKey", (JsonSerializable)this.wrappedContentKey).writeJsonField("EncryptionAgent", (JsonSerializable)this.encryptionAgent).writeBinaryField("ContentEncryptionIV", this.contentEncryptionIV).writeJsonField("EncryptedRegionInfo", (JsonSerializable)this.encryptedRegionInfo).writeMapField("KeyWrappingMetadata", this.keyWrappingMetadata, JsonWriter::writeString).writeEndObject();
    }

    public static EncryptionData fromJson(JsonReader jsonReader) throws IOException {
        return (EncryptionData)jsonReader.readObject(reader -> {
            EncryptionData encryptionData = new EncryptionData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("EncryptionMode".equals(fieldName)) {
                    encryptionData.encryptionMode = reader.getString();
                    continue;
                }
                if ("WrappedContentKey".equals(fieldName)) {
                    encryptionData.wrappedContentKey = WrappedKey.fromJson(reader);
                    continue;
                }
                if ("EncryptionAgent".equals(fieldName)) {
                    encryptionData.encryptionAgent = EncryptionAgent.fromJson(reader);
                    continue;
                }
                if ("ContentEncryptionIV".equals(fieldName)) {
                    encryptionData.contentEncryptionIV = reader.getBinary();
                    continue;
                }
                if ("EncryptedRegionInfo".equals(fieldName)) {
                    encryptionData.encryptedRegionInfo = EncryptedRegionInfo.fromJson(reader);
                    continue;
                }
                if ("KeyWrappingMetadata".equals(fieldName)) {
                    encryptionData.keyWrappingMetadata = reader.readMap(JsonReader::getString);
                    continue;
                }
                reader.skipChildren();
            }
            return encryptionData;
        });
    }
}

