/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized.cryptography;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.specialized.cryptography.EncryptionData;

final class EncryptedBlobLength {
    private static final ClientLogger LOGGER = new ClientLogger(EncryptedBlobLength.class);

    EncryptedBlobLength() {
    }

    static Long computeAdjustedBlobLength(EncryptionData encryptionData, Long encryptedLength) {
        switch (encryptionData.getEncryptionAgent().getProtocol()) {
            case "1.0": {
                return encryptedLength;
            }
            case "2.0": 
            case "2.1": {
                long regionLength = encryptionData.getEncryptedRegionInfo().getDataLength();
                long region = (long)Math.ceil((double)encryptedLength.longValue() / (double)(regionLength + 12L + 16L));
                long offset = 28L * region;
                return encryptedLength - offset;
            }
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Unexpected protocol version"));
    }
}

