/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.repository.query;

import com.azure.spring.data.cosmos.core.mapping.CosmosPersistentProperty;
import com.azure.spring.data.cosmos.core.query.CosmosQuery;
import com.azure.spring.data.cosmos.core.query.Criteria;
import com.azure.spring.data.cosmos.core.query.CriteriaType;
import com.azure.spring.data.cosmos.repository.query.CosmosParameterAccessor;
import com.azure.spring.data.cosmos.repository.support.CosmosEntityInformation;
import java.util.ArrayList;
import java.util.Iterator;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class CosmosQueryCreator
extends AbstractQueryCreator<CosmosQuery, Criteria> {
    private final MappingContext<?, CosmosPersistentProperty> mappingContext;

    public CosmosQueryCreator(PartTree tree, CosmosParameterAccessor accessor, MappingContext<?, CosmosPersistentProperty> mappingContext) {
        super(tree, (ParameterAccessor)accessor);
        this.mappingContext = mappingContext;
    }

    private String getSubject(@NonNull Part part) {
        String subject = this.mappingContext.getPersistentPropertyPath(part.getProperty()).toDotPath();
        Class domainType = part.getProperty().getOwningType().getType();
        CosmosEntityInformation information = new CosmosEntityInformation(domainType);
        if (information.getIdField().getName().equals(subject)) {
            subject = "id";
        }
        return subject;
    }

    protected Criteria create(Part part, Iterator<Object> parameters) {
        Part.Type type = part.getType();
        String subject = this.getSubject(part);
        ArrayList<Object> values = new ArrayList<Object>();
        if (CriteriaType.isPartTypeUnSupported(type)) {
            throw new UnsupportedOperationException("Unsupported keyword: " + String.valueOf(type));
        }
        for (int i = 0; i < part.getNumberOfArguments(); ++i) {
            Assert.isTrue((boolean)parameters.hasNext(), (String)"should not reach the end of iterator");
            values.add(parameters.next());
        }
        return Criteria.getInstance(CriteriaType.toCriteriaType(type), subject, values, part.shouldIgnoreCase());
    }

    protected Criteria and(@NonNull Part part, @NonNull Criteria base, @NonNull Iterator<Object> parameters) {
        Object right = this.create(part, (Iterator)parameters);
        return Criteria.getInstance(CriteriaType.AND, base, (Criteria)right);
    }

    protected Criteria or(@NonNull Criteria base, @NonNull Criteria criteria) {
        return Criteria.getInstance(CriteriaType.OR, base, criteria);
    }

    protected CosmosQuery complete(@NonNull Criteria criteria, @NonNull Sort sort) {
        return new CosmosQuery(criteria).with(sort);
    }
}

