/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.core.mapping;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.mapping.model.SimpleTypeHolder;

final class CosmosSimpleTypes {
    private static final Set<Class<?>> COSMOS_SIMPLE_TYPES;
    public static final SimpleTypeHolder HOLDER;

    CosmosSimpleTypes() {
    }

    static {
        HashSet<Class<BigInteger>> simpleTypes = new HashSet<Class<BigInteger>>();
        simpleTypes.add(UUID.class);
        simpleTypes.add(BigDecimal.class);
        simpleTypes.add(BigInteger.class);
        COSMOS_SIMPLE_TYPES = Collections.unmodifiableSet(simpleTypes);
        HOLDER = new SimpleTypeHolder(COSMOS_SIMPLE_TYPES, true){

            public boolean isSimpleType(Class<?> type) {
                if (type.isEnum()) {
                    return true;
                }
                return super.isSimpleType(type);
            }
        };
    }
}

