/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.core.mapping;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.mapping.model.SimpleTypeHolder;

final class CosmosSimpleTypes {
    private static final Set<Class<?>> COSMOS_SIMPLE_TYPES;
    public static final SimpleTypeHolder HOLDER;

    CosmosSimpleTypes() {
    }

    static {
        HashSet<Class<UUID>> simpleTypes = new HashSet<Class<UUID>>();
        simpleTypes.add(UUID.class);
        COSMOS_SIMPLE_TYPES = Collections.unmodifiableSet(simpleTypes);
        HOLDER = new SimpleTypeHolder(COSMOS_SIMPLE_TYPES, true){

            public boolean isSimpleType(Class<?> type) {
                if (type.isEnum()) {
                    return true;
                }
                return super.isSimpleType(type);
            }
        };
    }
}

