// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.secrets.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * The secret set parameters.
 */
@Fluent
public final class SecretSetParameters implements JsonSerializable<SecretSetParameters> {
    /*
     * The value of the secret.
     */
    private String value;

    /*
     * Application specific metadata in the form of key-value pairs.
     */
    private Map<String, String> tags;

    /*
     * Type of the secret value such as a password.
     */
    private String secretContentType;

    /*
     * The secret management attributes.
     */
    private SecretAttributes secretAttributes;

    /**
     * Creates an instance of SecretSetParameters class.
     */
    public SecretSetParameters() {
    }

    /**
     * Get the value property: The value of the secret.
     * 
     * @return the value value.
     */
    public String getValue() {
        return this.value;
    }

    /**
     * Set the value property: The value of the secret.
     * 
     * @param value the value value to set.
     * @return the SecretSetParameters object itself.
     */
    public SecretSetParameters setValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Get the tags property: Application specific metadata in the form of key-value pairs.
     * 
     * @return the tags value.
     */
    public Map<String, String> getTags() {
        return this.tags;
    }

    /**
     * Set the tags property: Application specific metadata in the form of key-value pairs.
     * 
     * @param tags the tags value to set.
     * @return the SecretSetParameters object itself.
     */
    public SecretSetParameters setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the secretContentType property: Type of the secret value such as a password.
     * 
     * @return the secretContentType value.
     */
    public String getSecretContentType() {
        return this.secretContentType;
    }

    /**
     * Set the secretContentType property: Type of the secret value such as a password.
     * 
     * @param secretContentType the secretContentType value to set.
     * @return the SecretSetParameters object itself.
     */
    public SecretSetParameters setSecretContentType(String secretContentType) {
        this.secretContentType = secretContentType;
        return this;
    }

    /**
     * Get the secretAttributes property: The secret management attributes.
     * 
     * @return the secretAttributes value.
     */
    public SecretAttributes getSecretAttributes() {
        return this.secretAttributes;
    }

    /**
     * Set the secretAttributes property: The secret management attributes.
     * 
     * @param secretAttributes the secretAttributes value to set.
     * @return the SecretSetParameters object itself.
     */
    public SecretSetParameters setSecretAttributes(SecretAttributes secretAttributes) {
        this.secretAttributes = secretAttributes;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("contentType", this.secretContentType);
        jsonWriter.writeJsonField("attributes", this.secretAttributes);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SecretSetParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SecretSetParameters if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SecretSetParameters.
     */
    public static SecretSetParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecretSetParameters deserializedSecretSetParameters = new SecretSetParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    deserializedSecretSetParameters.value = reader.getString();
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedSecretSetParameters.tags = tags;
                } else if ("contentType".equals(fieldName)) {
                    deserializedSecretSetParameters.secretContentType = reader.getString();
                } else if ("attributes".equals(fieldName)) {
                    deserializedSecretSetParameters.secretAttributes = SecretAttributes.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSecretSetParameters;
        });
    }
}
