/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.secrets.models;

import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.Objects;

public class SecretProperties {
    private final ClientLogger logger = new ClientLogger(SecretProperties.class);
    String id;
    String version;
    Boolean enabled;
    OffsetDateTime notBefore;
    OffsetDateTime expiresOn;
    OffsetDateTime createdOn;
    OffsetDateTime updatedOn;
    String name;
    String recoveryLevel;
    @JsonProperty(value="contentType")
    String contentType;
    @JsonProperty(value="tags")
    Map<String, String> tags;
    @JsonProperty(value="kid", access=JsonProperty.Access.WRITE_ONLY)
    String keyId;
    @JsonProperty(value="managed", access=JsonProperty.Access.WRITE_ONLY)
    Boolean managed;
    @JsonProperty(value="recoverableDays", access=JsonProperty.Access.WRITE_ONLY)
    private Integer recoverableDays;

    SecretProperties(String secretName) {
        this.name = secretName;
    }

    public SecretProperties() {
    }

    public String getName() {
        return this.name;
    }

    public String getRecoveryLevel() {
        return this.recoveryLevel;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public SecretProperties setEnabled(Boolean enabled) {
        Objects.requireNonNull(enabled);
        this.enabled = enabled;
        return this;
    }

    public OffsetDateTime getNotBefore() {
        return this.notBefore;
    }

    public SecretProperties setNotBefore(OffsetDateTime notBefore) {
        this.notBefore = notBefore;
        return this;
    }

    public OffsetDateTime getExpiresOn() {
        if (this.expiresOn == null) {
            return null;
        }
        return this.expiresOn;
    }

    public SecretProperties setExpiresOn(OffsetDateTime expiresOn) {
        this.expiresOn = expiresOn;
        return this;
    }

    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    public OffsetDateTime getUpdatedOn() {
        return this.updatedOn;
    }

    public String getId() {
        return this.id;
    }

    public String getContentType() {
        return this.contentType;
    }

    public SecretProperties setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public SecretProperties setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public Boolean isManaged() {
        return this.managed;
    }

    public String getVersion() {
        return this.version;
    }

    public Integer getRecoverableDays() {
        return this.recoverableDays;
    }

    @JsonProperty(value="attributes")
    void unpackAttributes(Map<String, Object> attributes) {
        this.enabled = (Boolean)attributes.get("enabled");
        this.notBefore = this.epochToOffsetDateTime(attributes.get("nbf"));
        this.expiresOn = this.epochToOffsetDateTime(attributes.get("exp"));
        this.createdOn = this.epochToOffsetDateTime(attributes.get("created"));
        this.updatedOn = this.epochToOffsetDateTime(attributes.get("updated"));
        this.recoveryLevel = (String)attributes.get("recoveryLevel");
        this.contentType = (String)this.lazyValueSelection(attributes.get("contentType"), this.contentType);
        this.keyId = (String)this.lazyValueSelection(attributes.get("keyId"), this.keyId);
        this.tags = (Map)this.lazyValueSelection(attributes.get("tags"), this.tags);
        this.managed = (Boolean)this.lazyValueSelection(attributes.get("managed"), this.managed);
        this.recoverableDays = (Integer)attributes.get("recoverableDays");
        this.unpackId((String)attributes.get("id"));
    }

    @JsonProperty(value="id")
    void unpackId(String id) {
        if (id != null && id.length() > 0) {
            this.id = id;
            try {
                URL url = new URL(id);
                String[] tokens = url.getPath().split("/");
                this.name = tokens.length >= 3 ? tokens[2] : null;
                this.version = tokens.length >= 4 ? tokens[3] : null;
            }
            catch (MalformedURLException e) {
                this.logger.error("Received Malformed Secret Id URL from KV Service");
            }
        }
    }

    private OffsetDateTime epochToOffsetDateTime(Object epochValue) {
        if (epochValue != null) {
            Instant instant = Instant.ofEpochMilli(((Number)epochValue).longValue() * 1000L);
            return OffsetDateTime.ofInstant(instant, ZoneOffset.UTC);
        }
        return null;
    }

    private Object lazyValueSelection(Object input1, Object input2) {
        if (input1 == null) {
            return input2;
        }
        return input1;
    }
}

