/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.secrets.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.secrets.implementation.models.SecretAttributes;
import java.io.IOException;
import java.util.Map;

public final class SecretItem
implements JsonSerializable<SecretItem> {
    private String id;
    private SecretAttributes attributes;
    private Map<String, String> tags;
    private String contentType;
    private Boolean managed;

    private SecretItem() {
    }

    public String getId() {
        return this.id;
    }

    public SecretAttributes getAttributes() {
        return this.attributes;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Boolean isManaged() {
        return this.managed;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("attributes", (JsonSerializable)this.attributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("contentType", this.contentType);
        return jsonWriter.writeEndObject();
    }

    public static SecretItem fromJson(JsonReader jsonReader) throws IOException {
        return (SecretItem)jsonReader.readObject(reader -> {
            SecretItem deserializedSecretItem = new SecretItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSecretItem.id = reader.getString();
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    deserializedSecretItem.attributes = SecretAttributes.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedSecretItem.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("contentType".equals(fieldName)) {
                    deserializedSecretItem.contentType = reader.getString();
                    continue;
                }
                if ("managed".equals(fieldName)) {
                    deserializedSecretItem.managed = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecretItem;
        });
    }
}

