/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import com.azure.security.keyvault.keys.cryptography.CryptographyClientBuilder;
import com.azure.security.keyvault.keys.cryptography.CryptographyServiceVersion;
import com.azure.security.keyvault.keys.cryptography.implementation.CryptographyClientImpl;
import com.azure.security.keyvault.keys.cryptography.implementation.CryptographyUtils;
import com.azure.security.keyvault.keys.cryptography.implementation.LocalKeyCryptographyClient;
import com.azure.security.keyvault.keys.cryptography.models.DecryptParameters;
import com.azure.security.keyvault.keys.cryptography.models.DecryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptParameters;
import com.azure.security.keyvault.keys.cryptography.models.EncryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.KeyWrapAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.SignResult;
import com.azure.security.keyvault.keys.cryptography.models.SignatureAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.UnwrapResult;
import com.azure.security.keyvault.keys.cryptography.models.VerifyResult;
import com.azure.security.keyvault.keys.cryptography.models.WrapResult;
import com.azure.security.keyvault.keys.implementation.KeyClientImpl;
import com.azure.security.keyvault.keys.implementation.SecretMinClientImpl;
import com.azure.security.keyvault.keys.models.JsonWebKey;
import com.azure.security.keyvault.keys.models.KeyVaultKey;
import java.util.Objects;

@ServiceClient(builder=CryptographyClientBuilder.class, serviceInterfaces={KeyClientImpl.KeyClientService.class, SecretMinClientImpl.SecretMinClientService.class})
public class CryptographyClient {
    private static final ClientLogger LOGGER = new ClientLogger(CryptographyClient.class);
    private volatile boolean skipLocalClientCreation;
    private volatile LocalKeyCryptographyClient localKeyCryptographyClient;
    final CryptographyClientImpl implClient;
    final String keyId;

    CryptographyClient(String keyId, HttpPipeline pipeline, CryptographyServiceVersion version, boolean disableKeyCaching) {
        this.implClient = new CryptographyClientImpl(keyId, pipeline, version);
        this.keyId = keyId;
        this.skipLocalClientCreation = disableKeyCaching;
    }

    CryptographyClient(JsonWebKey jsonWebKey) {
        Objects.requireNonNull(jsonWebKey, "The JSON Web Key is required.");
        if (!jsonWebKey.isValid()) {
            throw new IllegalArgumentException("The JSON Web Key is not valid.");
        }
        if (jsonWebKey.getKeyOps() == null) {
            throw new IllegalArgumentException("The JSON Web Key's key operations property is not configured.");
        }
        if (jsonWebKey.getKeyType() == null) {
            throw new IllegalArgumentException("The JSON Web Key's key type property is not configured.");
        }
        this.implClient = null;
        this.keyId = jsonWebKey.getId();
        try {
            this.localKeyCryptographyClient = CryptographyUtils.createLocalClient(jsonWebKey, null);
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Could not initialize local cryptography client.", e));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey getKey() {
        return (KeyVaultKey)this.getKeyWithResponse(Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> getKeyWithResponse(Context context) {
        if (this.implClient != null) {
            return this.implClient.getKey(context);
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Operation not supported when operating in local-only mode."));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public EncryptResult encrypt(EncryptionAlgorithm algorithm, byte[] plaintext) {
        return this.encrypt(algorithm, plaintext, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public EncryptResult encrypt(EncryptionAlgorithm algorithm, byte[] plaintext, Context context) {
        if (this.isLocalClientAvailable()) {
            try {
                return this.localKeyCryptographyClient.encrypt(algorithm, plaintext, context);
            }
            catch (RuntimeException e) {
                throw LOGGER.logExceptionAsError(e);
            }
        }
        return this.implClient.encrypt(algorithm, plaintext, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public EncryptResult encrypt(EncryptParameters encryptParameters, Context context) {
        if (this.isLocalClientAvailable()) {
            try {
                return this.localKeyCryptographyClient.encrypt(encryptParameters, context);
            }
            catch (RuntimeException e) {
                throw LOGGER.logExceptionAsError(e);
            }
        }
        return this.implClient.encrypt(encryptParameters, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DecryptResult decrypt(EncryptionAlgorithm algorithm, byte[] ciphertext) {
        return this.decrypt(algorithm, ciphertext, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DecryptResult decrypt(EncryptionAlgorithm algorithm, byte[] ciphertext, Context context) {
        if (this.isLocalClientAvailable()) {
            try {
                return this.localKeyCryptographyClient.decrypt(algorithm, ciphertext, context);
            }
            catch (RuntimeException e) {
                throw LOGGER.logExceptionAsError(e);
            }
        }
        return this.implClient.decrypt(algorithm, ciphertext, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DecryptResult decrypt(DecryptParameters decryptParameters, Context context) {
        if (this.isLocalClientAvailable()) {
            try {
                return this.localKeyCryptographyClient.decrypt(decryptParameters, context);
            }
            catch (RuntimeException e) {
                throw LOGGER.logExceptionAsError(e);
            }
        }
        return this.implClient.decrypt(decryptParameters, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SignResult sign(SignatureAlgorithm algorithm, byte[] digest) {
        return this.sign(algorithm, digest, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SignResult sign(SignatureAlgorithm algorithm, byte[] digest, Context context) {
        if (this.isLocalClientAvailable()) {
            try {
                return this.localKeyCryptographyClient.sign(algorithm, digest, context);
            }
            catch (RuntimeException e) {
                throw LOGGER.logExceptionAsError(e);
            }
        }
        return this.implClient.sign(algorithm, digest, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public VerifyResult verify(SignatureAlgorithm algorithm, byte[] digest, byte[] signature) {
        return this.verify(algorithm, digest, signature, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public VerifyResult verify(SignatureAlgorithm algorithm, byte[] digest, byte[] signature, Context context) {
        if (this.isLocalClientAvailable()) {
            try {
                return this.localKeyCryptographyClient.verify(algorithm, digest, signature, context);
            }
            catch (RuntimeException e) {
                throw LOGGER.logExceptionAsError(e);
            }
        }
        return this.implClient.verify(algorithm, digest, signature, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public WrapResult wrapKey(KeyWrapAlgorithm algorithm, byte[] key) {
        return this.wrapKey(algorithm, key, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public WrapResult wrapKey(KeyWrapAlgorithm algorithm, byte[] key, Context context) {
        if (this.isLocalClientAvailable()) {
            try {
                return this.localKeyCryptographyClient.wrapKey(algorithm, key, context);
            }
            catch (RuntimeException e) {
                throw LOGGER.logExceptionAsError(e);
            }
        }
        return this.implClient.wrapKey(algorithm, key, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public UnwrapResult unwrapKey(KeyWrapAlgorithm algorithm, byte[] encryptedKey) {
        return this.unwrapKey(algorithm, encryptedKey, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public UnwrapResult unwrapKey(KeyWrapAlgorithm algorithm, byte[] encryptedKey, Context context) {
        if (this.isLocalClientAvailable()) {
            try {
                return this.localKeyCryptographyClient.unwrapKey(algorithm, encryptedKey, context);
            }
            catch (RuntimeException e) {
                throw LOGGER.logExceptionAsError(e);
            }
        }
        return this.implClient.unwrapKey(algorithm, encryptedKey, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SignResult signData(SignatureAlgorithm algorithm, byte[] data) {
        return this.signData(algorithm, data, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SignResult signData(SignatureAlgorithm algorithm, byte[] data, Context context) {
        if (this.isLocalClientAvailable()) {
            try {
                return this.localKeyCryptographyClient.signData(algorithm, data, context);
            }
            catch (RuntimeException e) {
                throw LOGGER.logExceptionAsError(e);
            }
        }
        return this.implClient.signData(algorithm, data, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public VerifyResult verifyData(SignatureAlgorithm algorithm, byte[] data, byte[] signature) {
        return this.verifyData(algorithm, data, signature, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public VerifyResult verifyData(SignatureAlgorithm algorithm, byte[] data, byte[] signature, Context context) {
        if (this.isLocalClientAvailable()) {
            try {
                return this.localKeyCryptographyClient.verifyData(algorithm, data, signature, context);
            }
            catch (RuntimeException e) {
                throw LOGGER.logExceptionAsError(e);
            }
        }
        return this.implClient.verifyData(algorithm, data, signature, context);
    }

    String getVaultUrl() {
        return this.implClient.getVaultUrl();
    }

    private boolean isLocalClientAvailable() {
        if (!this.skipLocalClientCreation && this.localKeyCryptographyClient == null) {
            try {
                this.localKeyCryptographyClient = CryptographyUtils.retrieveJwkAndCreateLocalClient(this.implClient);
            }
            catch (Throwable t) {
                if (CryptographyUtils.isThrowableRetryable(t)) {
                    LOGGER.log(LogLevel.VERBOSE, () -> "Could not set up local cryptography for this operation. Defaulting to service-side cryptography.", t);
                }
                this.skipLocalClientCreation = true;
                LOGGER.log(LogLevel.VERBOSE, () -> "Could not set up local cryptography. Defaulting to service-side cryptography for all operations.", t);
            }
        }
        return this.localKeyCryptographyClient != null;
    }
}

