/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.keys.implementation.models.JsonWebKey;
import com.azure.security.keyvault.keys.implementation.models.KeyAttributes;
import com.azure.security.keyvault.keys.implementation.models.KeyReleasePolicy;
import java.io.IOException;
import java.util.Map;

public final class KeyImportParameters
implements JsonSerializable<KeyImportParameters> {
    private Boolean hsm;
    private final JsonWebKey key;
    private KeyAttributes keyAttributes;
    private Map<String, String> tags;
    private KeyReleasePolicy releasePolicy;

    public KeyImportParameters(JsonWebKey key) {
        this.key = key;
    }

    public Boolean isHsm() {
        return this.hsm;
    }

    public KeyImportParameters setHsm(Boolean hsm) {
        this.hsm = hsm;
        return this;
    }

    public JsonWebKey getKey() {
        return this.key;
    }

    public KeyAttributes getKeyAttributes() {
        return this.keyAttributes;
    }

    public KeyImportParameters setKeyAttributes(KeyAttributes keyAttributes) {
        this.keyAttributes = keyAttributes;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public KeyImportParameters setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public KeyReleasePolicy getReleasePolicy() {
        return this.releasePolicy;
    }

    public KeyImportParameters setReleasePolicy(KeyReleasePolicy releasePolicy) {
        this.releasePolicy = releasePolicy;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("key", (JsonSerializable)this.key);
        jsonWriter.writeBooleanField("Hsm", this.hsm);
        jsonWriter.writeJsonField("attributes", (JsonSerializable)this.keyAttributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("release_policy", (JsonSerializable)this.releasePolicy);
        return jsonWriter.writeEndObject();
    }

    public static KeyImportParameters fromJson(JsonReader jsonReader) throws IOException {
        return (KeyImportParameters)jsonReader.readObject(reader -> {
            JsonWebKey key = null;
            Boolean hsm = null;
            KeyAttributes keyAttributes = null;
            Map tags = null;
            KeyReleasePolicy releasePolicy = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    key = JsonWebKey.fromJson(reader);
                    continue;
                }
                if ("Hsm".equals(fieldName)) {
                    hsm = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    keyAttributes = KeyAttributes.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("release_policy".equals(fieldName)) {
                    releasePolicy = KeyReleasePolicy.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            KeyImportParameters deserializedKeyImportParameters = new KeyImportParameters(key);
            deserializedKeyImportParameters.hsm = hsm;
            deserializedKeyImportParameters.keyAttributes = keyAttributes;
            deserializedKeyImportParameters.tags = tags;
            deserializedKeyImportParameters.releasePolicy = releasePolicy;
            return deserializedKeyImportParameters;
        });
    }
}

