/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingContext;
import com.azure.security.keyvault.keys.KeyClientBuilder;
import com.azure.security.keyvault.keys.KeyServiceVersion;
import com.azure.security.keyvault.keys.cryptography.CryptographyAsyncClient;
import com.azure.security.keyvault.keys.implementation.KeyClientImpl;
import com.azure.security.keyvault.keys.implementation.KeyVaultKeysUtils;
import com.azure.security.keyvault.keys.implementation.models.BackupKeyResult;
import com.azure.security.keyvault.keys.implementation.models.DeletedKeyBundle;
import com.azure.security.keyvault.keys.implementation.models.DeletedKeyItem;
import com.azure.security.keyvault.keys.implementation.models.GetRandomBytesRequest;
import com.azure.security.keyvault.keys.implementation.models.KeyBundle;
import com.azure.security.keyvault.keys.implementation.models.KeyCreateParameters;
import com.azure.security.keyvault.keys.implementation.models.KeyImportParameters;
import com.azure.security.keyvault.keys.implementation.models.KeyItem;
import com.azure.security.keyvault.keys.implementation.models.KeyReleaseParameters;
import com.azure.security.keyvault.keys.implementation.models.KeyRestoreParameters;
import com.azure.security.keyvault.keys.implementation.models.KeyUpdateParameters;
import com.azure.security.keyvault.keys.implementation.models.KeyVaultKeysModelsUtils;
import com.azure.security.keyvault.keys.implementation.models.RandomBytes;
import com.azure.security.keyvault.keys.models.CreateEcKeyOptions;
import com.azure.security.keyvault.keys.models.CreateKeyOptions;
import com.azure.security.keyvault.keys.models.CreateOctKeyOptions;
import com.azure.security.keyvault.keys.models.CreateRsaKeyOptions;
import com.azure.security.keyvault.keys.models.DeletedKey;
import com.azure.security.keyvault.keys.models.ImportKeyOptions;
import com.azure.security.keyvault.keys.models.JsonWebKey;
import com.azure.security.keyvault.keys.models.KeyExportEncryptionAlgorithm;
import com.azure.security.keyvault.keys.models.KeyOperation;
import com.azure.security.keyvault.keys.models.KeyProperties;
import com.azure.security.keyvault.keys.models.KeyRotationPolicy;
import com.azure.security.keyvault.keys.models.KeyType;
import com.azure.security.keyvault.keys.models.KeyVaultKey;
import com.azure.security.keyvault.keys.models.ReleaseKeyOptions;
import com.azure.security.keyvault.keys.models.ReleaseKeyResult;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=KeyClientBuilder.class, isAsync=true, serviceInterfaces={KeyClientImpl.KeyClientService.class})
public final class KeyAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(KeyAsyncClient.class);
    private final KeyClientImpl implClient;
    private final String vaultUrl;
    private final KeyServiceVersion serviceVersion;

    KeyAsyncClient(KeyClientImpl implClient, String vaultUrl, KeyServiceVersion keyServiceVersion) {
        this.implClient = implClient;
        this.vaultUrl = vaultUrl;
        this.serviceVersion = keyServiceVersion;
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    HttpPipeline getHttpPipeline() {
        return this.implClient.getHttpPipeline();
    }

    public CryptographyAsyncClient getCryptographyAsyncClient(String keyName) {
        return this.getCryptographyAsyncClient(keyName, null);
    }

    public CryptographyAsyncClient getCryptographyAsyncClient(String keyName, String keyVersion) {
        return KeyVaultKeysUtils.getCryptographyClientBuilder(keyName, keyVersion, this.vaultUrl, this.getHttpPipeline(), this.serviceVersion).buildAsyncClient();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> createKey(String name, KeyType keyType) {
        return this.createKeyWithResponse(new CreateKeyOptions(name, keyType)).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> createKeyWithResponse(CreateKeyOptions createKeyOptions) {
        try {
            if (createKeyOptions == null) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'createKeyOptions' cannot be null."));
            }
            KeyCreateParameters keyCreateParameters = new KeyCreateParameters(createKeyOptions.getKeyType()).setKeyOps(createKeyOptions.getKeyOperations()).setKeyAttributes(KeyVaultKeysModelsUtils.createKeyAttributes(createKeyOptions)).setTags(createKeyOptions.getTags()).setReleasePolicy(KeyVaultKeysModelsUtils.mapKeyReleasePolicy(createKeyOptions.getReleasePolicy()));
            return this.implClient.createKeyWithResponseAsync(createKeyOptions.getName(), BinaryData.fromObject((Object)keyCreateParameters), KeyVaultKeysUtils.EMPTY_OPTIONS).onErrorMap(HttpResponseException.class, KeyAsyncClient::mapCreateKeyException).map(response -> new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)((BinaryData)response.getValue()).toObject(KeyBundle.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    static HttpResponseException mapCreateKeyException(HttpResponseException e) {
        return e.getResponse().getStatusCode() == 400 ? new ResourceModifiedException(e.getMessage(), e.getResponse(), e.getValue()) : e;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> createKey(CreateKeyOptions createKeyOptions) {
        return this.createKeyWithResponse(createKeyOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> createRsaKey(CreateRsaKeyOptions createRsaKeyOptions) {
        return this.createRsaKeyWithResponse(createRsaKeyOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> createRsaKeyWithResponse(CreateRsaKeyOptions createRsaKeyOptions) {
        try {
            if (createRsaKeyOptions == null) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'createRsaKeyOptions' cannot be null."));
            }
            KeyCreateParameters keyCreateParameters = new KeyCreateParameters(createRsaKeyOptions.getKeyType()).setKeySize(createRsaKeyOptions.getKeySize()).setPublicExponent(createRsaKeyOptions.getPublicExponent()).setKeyOps(createRsaKeyOptions.getKeyOperations()).setKeyAttributes(KeyVaultKeysModelsUtils.createKeyAttributes(createRsaKeyOptions)).setTags(createRsaKeyOptions.getTags()).setReleasePolicy(KeyVaultKeysModelsUtils.mapKeyReleasePolicy(createRsaKeyOptions.getReleasePolicy()));
            return this.implClient.createKeyWithResponseAsync(createRsaKeyOptions.getName(), BinaryData.fromObject((Object)keyCreateParameters), KeyVaultKeysUtils.EMPTY_OPTIONS).onErrorMap(HttpResponseException.class, KeyAsyncClient::mapCreateKeyException).map(response -> new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)((BinaryData)response.getValue()).toObject(KeyBundle.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> createEcKey(CreateEcKeyOptions createEcKeyOptions) {
        return this.createEcKeyWithResponse(createEcKeyOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> createEcKeyWithResponse(CreateEcKeyOptions createEcKeyOptions) {
        try {
            if (createEcKeyOptions == null) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'createEcKeyOptions' cannot be null."));
            }
            KeyCreateParameters keyCreateParameters = new KeyCreateParameters(createEcKeyOptions.getKeyType()).setKeyOps(createEcKeyOptions.getKeyOperations()).setKeyAttributes(KeyVaultKeysModelsUtils.createKeyAttributes(createEcKeyOptions)).setTags(createEcKeyOptions.getTags()).setCurve(createEcKeyOptions.getCurveName()).setReleasePolicy(KeyVaultKeysModelsUtils.mapKeyReleasePolicy(createEcKeyOptions.getReleasePolicy()));
            return this.implClient.createKeyWithResponseAsync(createEcKeyOptions.getName(), BinaryData.fromObject((Object)keyCreateParameters), KeyVaultKeysUtils.EMPTY_OPTIONS).onErrorMap(HttpResponseException.class, KeyAsyncClient::mapCreateKeyException).map(response -> new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)((BinaryData)response.getValue()).toObject(KeyBundle.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> createOctKey(CreateOctKeyOptions createOctKeyOptions) {
        return this.createOctKeyWithResponse(createOctKeyOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> createOctKeyWithResponse(CreateOctKeyOptions createOctKeyOptions) {
        try {
            if (createOctKeyOptions == null) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'createOctKeyOptions' cannot be null."));
            }
            KeyCreateParameters keyCreateParameters = new KeyCreateParameters(createOctKeyOptions.getKeyType()).setKeySize(createOctKeyOptions.getKeySize()).setKeyOps(createOctKeyOptions.getKeyOperations()).setKeyAttributes(KeyVaultKeysModelsUtils.createKeyAttributes(createOctKeyOptions)).setTags(createOctKeyOptions.getTags()).setReleasePolicy(KeyVaultKeysModelsUtils.mapKeyReleasePolicy(createOctKeyOptions.getReleasePolicy()));
            return this.implClient.createKeyWithResponseAsync(createOctKeyOptions.getName(), BinaryData.fromObject((Object)keyCreateParameters), KeyVaultKeysUtils.EMPTY_OPTIONS).onErrorMap(HttpResponseException.class, KeyAsyncClient::mapCreateKeyException).map(response -> new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)((BinaryData)response.getValue()).toObject(KeyBundle.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> importKey(String name, JsonWebKey keyMaterial) {
        return this.importKeyWithResponse(new ImportKeyOptions(name, keyMaterial)).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> importKey(ImportKeyOptions importKeyOptions) {
        return this.importKeyWithResponse(importKeyOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> importKeyWithResponse(ImportKeyOptions importKeyOptions) {
        try {
            if (importKeyOptions == null) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new RuntimeException("'importKeyOptions' cannot be null."));
            }
            KeyImportParameters keyImportParameters = new KeyImportParameters(KeyVaultKeysModelsUtils.mapJsonWebKey(importKeyOptions.getKey())).setHsm(importKeyOptions.isHardwareProtected()).setKeyAttributes(KeyVaultKeysModelsUtils.createKeyAttributes(importKeyOptions)).setTags(importKeyOptions.getTags()).setReleasePolicy(KeyVaultKeysModelsUtils.mapKeyReleasePolicy(importKeyOptions.getReleasePolicy()));
            return this.implClient.importKeyWithResponseAsync(importKeyOptions.getName(), BinaryData.fromObject((Object)keyImportParameters), KeyVaultKeysUtils.EMPTY_OPTIONS).map(response -> new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)((BinaryData)response.getValue()).toObject(KeyBundle.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> getKey(String name, String version) {
        return this.getKeyWithResponse(name, version).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> getKeyWithResponse(String name, String version) {
        try {
            return this.implClient.getKeyWithResponseAsync(name, version, KeyVaultKeysUtils.EMPTY_OPTIONS).onErrorMap(HttpResponseException.class, KeyAsyncClient::mapGetKeyException).map(response -> new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)((BinaryData)response.getValue()).toObject(KeyBundle.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    static HttpResponseException mapGetKeyException(HttpResponseException e) {
        return e.getResponse().getStatusCode() == 403 ? new ResourceModifiedException(e.getMessage(), e.getResponse(), e.getValue()) : e;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> getKey(String name) {
        return this.getKeyWithResponse(name, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> updateKeyPropertiesWithResponse(KeyProperties keyProperties, KeyOperation ... keyOperations) {
        try {
            if (keyProperties == null) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'keyProperties' cannot be null."));
            }
            KeyUpdateParameters keyUpdateParameters = new KeyUpdateParameters().setKeyOps(keyOperations == null ? null : Arrays.asList(keyOperations)).setKeyAttributes(KeyVaultKeysModelsUtils.createKeyAttributes(keyProperties)).setTags(keyProperties.getTags()).setReleasePolicy(KeyVaultKeysModelsUtils.mapKeyReleasePolicy(keyProperties.getReleasePolicy()));
            return this.implClient.updateKeyWithResponseAsync(keyProperties.getName(), keyProperties.getVersion(), BinaryData.fromObject((Object)keyUpdateParameters), KeyVaultKeysUtils.EMPTY_OPTIONS).map(response -> new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)((BinaryData)response.getValue()).toObject(KeyBundle.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> updateKeyProperties(KeyProperties keyProperties, KeyOperation ... keyOperations) {
        return this.updateKeyPropertiesWithResponse(keyProperties, keyOperations).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DeletedKey, Void> beginDeleteKey(String name) {
        return new PollerFlux(Duration.ofSeconds(1L), this.deleteActivationOperation(name), this.deletePollOperation(name), (context, firstResponse) -> Mono.empty(), context -> Mono.empty());
    }

    private Function<PollingContext<DeletedKey>, Mono<DeletedKey>> deleteActivationOperation(String name) {
        return pollingContext -> this.implClient.deleteKeyWithResponseAsync(name, KeyVaultKeysUtils.EMPTY_OPTIONS).map(response -> KeyVaultKeysModelsUtils.createDeletedKey((DeletedKeyBundle)((BinaryData)response.getValue()).toObject(DeletedKeyBundle.class)));
    }

    private Function<PollingContext<DeletedKey>, Mono<PollResponse<DeletedKey>>> deletePollOperation(String name) {
        return pollingContext -> this.implClient.getDeletedKeyWithResponseAsync(name, KeyVaultKeysUtils.EMPTY_OPTIONS).map(response -> new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)KeyVaultKeysModelsUtils.createDeletedKey((DeletedKeyBundle)((BinaryData)response.getValue()).toObject(DeletedKeyBundle.class)))).onErrorResume(HttpResponseException.class, e -> {
            if (e.getResponse().getStatusCode() == 404) {
                return Mono.just((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((DeletedKey)pollingContext.getLatestResponse().getValue())));
            }
            return Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedKey)pollingContext.getLatestResponse().getValue())));
        }).onErrorReturn((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedKey)pollingContext.getLatestResponse().getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeletedKey> getDeletedKey(String name) {
        return this.getDeletedKeyWithResponse(name).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeletedKey>> getDeletedKeyWithResponse(String name) {
        try {
            return this.implClient.getDeletedKeyWithResponseAsync(name, KeyVaultKeysUtils.EMPTY_OPTIONS).map(response -> new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.createDeletedKey((DeletedKeyBundle)((BinaryData)response.getValue()).toObject(DeletedKeyBundle.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> purgeDeletedKey(String name) {
        return this.purgeDeletedKeyWithResponse(name).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> purgeDeletedKeyWithResponse(String name) {
        try {
            return this.implClient.purgeDeletedKeyWithResponseAsync(name, KeyVaultKeysUtils.EMPTY_OPTIONS);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<KeyVaultKey, Void> beginRecoverDeletedKey(String name) {
        return new PollerFlux(Duration.ofSeconds(1L), this.recoverActivationOperation(name), this.recoverPollOperation(name), (context, firstResponse) -> Mono.empty(), context -> Mono.empty());
    }

    private Function<PollingContext<KeyVaultKey>, Mono<KeyVaultKey>> recoverActivationOperation(String name) {
        return pollingContext -> this.implClient.recoverDeletedKeyWithResponseAsync(name, KeyVaultKeysUtils.EMPTY_OPTIONS).map(response -> KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)((BinaryData)response.getValue()).toObject(KeyBundle.class)));
    }

    private Function<PollingContext<KeyVaultKey>, Mono<PollResponse<KeyVaultKey>>> recoverPollOperation(String keyName) {
        return pollingContext -> this.implClient.getKeyWithResponseAsync(keyName, null, KeyVaultKeysUtils.EMPTY_OPTIONS).map(response -> new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)((BinaryData)response.getValue()).toObject(KeyBundle.class)))).onErrorResume(HttpResponseException.class, e -> {
            if (e.getResponse().getStatusCode() == 404) {
                return Mono.just((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((KeyVaultKey)pollingContext.getLatestResponse().getValue())));
            }
            return Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultKey)pollingContext.getLatestResponse().getValue())));
        }).onErrorReturn((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultKey)pollingContext.getLatestResponse().getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<byte[]> backupKey(String name) {
        return this.backupKeyWithResponse(name).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<byte[]>> backupKeyWithResponse(String name) {
        try {
            return this.implClient.backupKeyWithResponseAsync(name, KeyVaultKeysUtils.EMPTY_OPTIONS).map(response -> new SimpleResponse(response, (Object)((BackupKeyResult)((BinaryData)response.getValue()).toObject(BackupKeyResult.class)).getValue()));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> restoreKeyBackup(byte[] backup) {
        return this.restoreKeyBackupWithResponse(backup).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> restoreKeyBackupWithResponse(byte[] backup) {
        try {
            KeyRestoreParameters keyRestoreParameters = new KeyRestoreParameters(backup);
            return this.implClient.restoreKeyWithResponseAsync(BinaryData.fromObject((Object)keyRestoreParameters), KeyVaultKeysUtils.EMPTY_OPTIONS).onErrorMap(HttpResponseException.class, KeyAsyncClient::mapRestoreKeyException).map(response -> new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)((BinaryData)response.getValue()).toObject(KeyBundle.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    static HttpResponseException mapRestoreKeyException(HttpResponseException e) {
        return e.getResponse().getStatusCode() == 400 ? new ResourceModifiedException(e.getMessage(), e.getResponse(), e.getValue()) : e;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<KeyProperties> listPropertiesOfKeys() {
        PagedFlux<BinaryData> pagedFlux = this.implClient.getKeysAsync(KeyVaultKeysUtils.EMPTY_OPTIONS);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux pagedResponseFlux = continuationTokenParam == null ? pagedFlux.byPage().take(1L) : pagedFlux.byPage(continuationTokenParam).take(1L);
            return pagedResponseFlux.map(pagedResponse -> KeyAsyncClient.mapPagedResponse(pagedResponse, binaryData -> KeyVaultKeysModelsUtils.createKeyProperties((KeyItem)binaryData.toObject(KeyItem.class))));
        });
    }

    private static <T, R> PagedResponse<R> mapPagedResponse(PagedResponse<T> page, Function<T, R> itemMapper) {
        ArrayList<R> mappedValues = new ArrayList<R>(page.getValue().size());
        for (Object item : page.getValue()) {
            mappedValues.add(itemMapper.apply(item));
        }
        return new PagedResponseBase(page.getRequest(), page.getStatusCode(), page.getHeaders(), mappedValues, (String)page.getContinuationToken(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DeletedKey> listDeletedKeys() {
        PagedFlux<BinaryData> pagedFlux = this.implClient.getDeletedKeysAsync(KeyVaultKeysUtils.EMPTY_OPTIONS);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux pagedResponseFlux = continuationTokenParam == null ? pagedFlux.byPage().take(1L) : pagedFlux.byPage(continuationTokenParam).take(1L);
            return pagedResponseFlux.map(pagedResponse -> KeyAsyncClient.mapPagedResponse(pagedResponse, binaryData -> KeyVaultKeysModelsUtils.createDeletedKey((DeletedKeyItem)binaryData.toObject(DeletedKeyItem.class))));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<KeyProperties> listPropertiesOfKeyVersions(String name) {
        PagedFlux<BinaryData> pagedFlux = this.implClient.getKeyVersionsAsync(name, KeyVaultKeysUtils.EMPTY_OPTIONS);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux pagedResponseFlux = continuationTokenParam == null ? pagedFlux.byPage().take(1L) : pagedFlux.byPage(continuationTokenParam).take(1L);
            return pagedResponseFlux.map(pagedResponse -> KeyAsyncClient.mapPagedResponse(pagedResponse, binaryData -> KeyVaultKeysModelsUtils.createKeyProperties((KeyItem)binaryData.toObject(KeyItem.class))));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<byte[]> getRandomBytes(int count) {
        return this.getRandomBytesWithResponse(count).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<byte[]>> getRandomBytesWithResponse(int count) {
        try {
            GetRandomBytesRequest getRandomBytesRequest = new GetRandomBytesRequest(count);
            return FluxUtil.withContext(context -> this.implClient.getRandomBytesWithResponseAsync(BinaryData.fromObject((Object)getRandomBytesRequest), KeyVaultKeysUtils.EMPTY_OPTIONS).map(response -> new SimpleResponse(response, (Object)((RandomBytes)((BinaryData)response.getValue()).toObject(RandomBytes.class)).getValue())));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ReleaseKeyResult> releaseKey(String name, String targetAttestationToken) {
        return this.releaseKeyWithResponse(name, null, targetAttestationToken, new ReleaseKeyOptions()).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ReleaseKeyResult> releaseKey(String name, String version, String targetAttestationToken) {
        return this.releaseKeyWithResponse(name, version, targetAttestationToken, new ReleaseKeyOptions()).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ReleaseKeyResult>> releaseKeyWithResponse(String name, String version, String targetAttestationToken, ReleaseKeyOptions releaseKeyOptions) {
        try {
            if (CoreUtils.isNullOrEmpty((CharSequence)name) || CoreUtils.isNullOrEmpty((CharSequence)targetAttestationToken)) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'name' or 'targetAttestationToken' cannot be null or empty."));
            }
            String nonce = releaseKeyOptions == null ? null : releaseKeyOptions.getNonce();
            KeyExportEncryptionAlgorithm algorithm = releaseKeyOptions == null ? null : releaseKeyOptions.getAlgorithm();
            KeyReleaseParameters keyReleaseParameters = new KeyReleaseParameters(targetAttestationToken).setNonce(nonce).setEnc(algorithm);
            return this.implClient.releaseWithResponseAsync(name, version, BinaryData.fromObject((Object)keyReleaseParameters), KeyVaultKeysUtils.EMPTY_OPTIONS).map(binaryData -> new SimpleResponse(binaryData, (Object)((ReleaseKeyResult)((BinaryData)binaryData.getValue()).toObject(ReleaseKeyResult.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> rotateKey(String name) {
        return this.rotateKeyWithResponse(name).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> rotateKeyWithResponse(String name) {
        try {
            return this.implClient.rotateKeyWithResponseAsync(name, KeyVaultKeysUtils.EMPTY_OPTIONS).map(response -> new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)((BinaryData)response.getValue()).toObject(KeyBundle.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyRotationPolicy> getKeyRotationPolicy(String keyName) {
        return this.getKeyRotationPolicyWithResponse(keyName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyRotationPolicy>> getKeyRotationPolicyWithResponse(String keyName) {
        try {
            return this.implClient.getKeyRotationPolicyWithResponseAsync(keyName, KeyVaultKeysUtils.EMPTY_OPTIONS).map(response -> new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.mapKeyRotationPolicyImpl((com.azure.security.keyvault.keys.implementation.models.KeyRotationPolicy)((BinaryData)response.getValue()).toObject(com.azure.security.keyvault.keys.implementation.models.KeyRotationPolicy.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyRotationPolicy> updateKeyRotationPolicy(String keyName, KeyRotationPolicy keyRotationPolicy) {
        return this.updateKeyRotationPolicyWithResponse(keyName, keyRotationPolicy).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyRotationPolicy>> updateKeyRotationPolicyWithResponse(String keyName, KeyRotationPolicy keyRotationPolicy) {
        try {
            return this.implClient.updateKeyRotationPolicyWithResponseAsync(keyName, BinaryData.fromObject((Object)KeyVaultKeysModelsUtils.mapKeyRotationPolicy(keyRotationPolicy)), KeyVaultKeysUtils.EMPTY_OPTIONS).map(response -> new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.mapKeyRotationPolicyImpl((com.azure.security.keyvault.keys.implementation.models.KeyRotationPolicy)((BinaryData)response.getValue()).toObject(com.azure.security.keyvault.keys.implementation.models.KeyRotationPolicy.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> getKeyAttestation(String name) {
        return this.getKeyAttestationWithResponse(name, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> getKeyAttestationWithResponse(String name, String version) {
        try {
            return this.implClient.getKeyAttestationWithResponseAsync(name, version, KeyVaultKeysUtils.EMPTY_OPTIONS).onErrorMap(HttpResponseException.class, KeyAsyncClient::mapGetKeyException).map(response -> new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)((BinaryData)response.getValue()).toObject(KeyBundle.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }
}

