/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca.implementation.utils;

import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.asn1.pkcs.ContentInfo;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.cert.X509CertificateHolder;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.pkcs.PKCS12PfxPdu;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.pkcs.PKCS12SafeBag;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.pkcs.PKCS12SafeBagFactory;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.pkcs.PKCSException;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.pkcs.jcajce.JcePKCSPBEInputDecryptorProviderBuilder;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Base64;
import java.util.stream.Collectors;

public final class CertificateUtil {
    private static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERTIFICATE = "-----END CERTIFICATE-----";

    public static Certificate[] loadCertificatesFromSecretBundleValue(String string) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, PKCSException {
        if (string.contains(BEGIN_CERTIFICATE)) {
            return CertificateUtil.loadCertificatesFromSecretBundleValuePem(string);
        }
        return CertificateUtil.loadCertificatesFromSecretBundleValuePKCS12(string);
    }

    private static Certificate[] loadCertificatesFromSecretBundleValuePem(InputStream inputStream) throws IOException, CertificateException {
        ArrayList<Certificate> certificates = new ArrayList<Certificate>();
        StringBuilder builder = new StringBuilder();
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        while (reader.ready()) {
            String line = reader.readLine();
            if (line.contains(BEGIN_CERTIFICATE)) {
                builder = new StringBuilder();
            }
            builder.append(line).append('\n');
            if (!line.contains(END_CERTIFICATE)) continue;
            ByteArrayInputStream stream = new ByteArrayInputStream(builder.toString().getBytes());
            Certificate certificate = factory.generateCertificate(stream);
            certificates.add(certificate);
        }
        return certificates.toArray(new Certificate[0]);
    }

    private static Certificate[] loadCertificatesFromSecretBundleValuePem(String string) throws IOException, CertificateException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
        return CertificateUtil.loadCertificatesFromSecretBundleValuePem(inputStream);
    }

    private static Certificate[] loadCertificatesFromSecretBundleValuePKCS12(String string) throws IOException, CertificateException, PKCSException {
        ArrayList<Certificate> certificates = new ArrayList<Certificate>();
        PKCS12PfxPdu pfx = new PKCS12PfxPdu(Base64.getDecoder().decode(string.getBytes()));
        for (ContentInfo contentInfo : pfx.getContentInfos()) {
            PKCS12SafeBag[] safeBags;
            if (!contentInfo.getContentType().equals(PKCSObjectIdentifiers.encryptedData)) continue;
            PKCS12SafeBagFactory safeBagFactory = new PKCS12SafeBagFactory(contentInfo, new JcePKCSPBEInputDecryptorProviderBuilder().build("\u0000".toCharArray()));
            for (PKCS12SafeBag safeBag : safeBags = safeBagFactory.getSafeBags()) {
                Object bagValue = safeBag.getBagValue();
                if (!(bagValue instanceof X509CertificateHolder)) continue;
                CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream in = new ByteArrayInputStream(((X509CertificateHolder)bagValue).getEncoded());
                Certificate certificate = certFactory.generateCertificate(in);
                certificates.add(certificate);
            }
        }
        return certificates.toArray(new Certificate[0]);
    }

    public static Certificate loadX509CertificateFromFile(InputStream inputStream) throws CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        return factory.generateCertificate(inputStream);
    }

    public static Certificate[] loadX509CertificatesFromFile(InputStream inputStream) throws CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        return factory.generateCertificates(inputStream).stream().map(o -> o).collect(Collectors.toList()).toArray(new Certificate[0]);
    }

    public static String getCertificateNameFromCertificateItemId(String id) {
        String keyWord = "/certificates/";
        return id.substring(id.indexOf(keyWord) + keyWord.length());
    }
}

