/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.protocol;

import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.annotation.Contract;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.EntityDetails;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.HttpException;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.HttpRequest;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.HttpRequestInterceptor;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.MisdirectedRequestException;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.ProtocolException;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.URIScheme;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.protocol.HttpContext;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.protocol.HttpCoreContext;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.net.URIAuthority;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.util.Args;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.util.TextUtils;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestConformance
implements HttpRequestInterceptor {
    public static final RequestConformance INSTANCE = new RequestConformance();

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext localContext) throws HttpException, IOException {
        String hostName;
        Args.notNull(request, "HTTP request");
        if (TextUtils.isBlank(request.getScheme())) {
            throw new ProtocolException("Request scheme is not set");
        }
        if (TextUtils.isBlank(request.getPath())) {
            throw new ProtocolException("Request path is not set");
        }
        URIAuthority authority = request.getAuthority();
        if (authority != null && (URIScheme.HTTP.same(request.getScheme()) || URIScheme.HTTPS.same(request.getScheme())) && TextUtils.isBlank(hostName = authority.getHostName())) {
            throw new ProtocolException("Request host is empty");
        }
        HttpCoreContext context = HttpCoreContext.cast(localContext);
        if (URIScheme.HTTPS.same(request.getScheme()) && context.getSSLSession() == null) {
            throw new MisdirectedRequestException("HTTPS request over non-secure connection");
        }
    }
}

