/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.impl.nio;

import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.ConnectionReuseStrategy;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.EntityDetails;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.Header;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.HttpException;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.HttpRequest;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.HttpResponse;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.HttpVersion;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.ProtocolException;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.ProtocolVersion;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.UnsupportedHttpVersionException;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.config.Http1Config;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.impl.nio.FlushMode;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.impl.nio.Http1StreamChannel;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.impl.nio.MessageState;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.message.StatusLine;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.nio.CapacityChannel;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.nio.DataStreamChannel;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.nio.ResourceHolder;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.protocol.HttpContext;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.protocol.HttpCoreContext;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.protocol.HttpProcessor;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.util.Timeout;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

class ClientHttp1StreamHandler
implements ResourceHolder {
    public static final Timeout DEFAULT_WAIT_FOR_CONTINUE = Timeout.ofSeconds(3L);
    private final Http1StreamChannel<HttpRequest> outputChannel;
    private final DataStreamChannel internalDataChannel;
    private final HttpProcessor httpProcessor;
    private final Http1Config http1Config;
    private final ConnectionReuseStrategy connectionReuseStrategy;
    private final AsyncClientExchangeHandler exchangeHandler;
    private final HttpCoreContext context;
    private final AtomicReference<MessageState> requestState;
    private final AtomicReference<MessageState> responseState;
    private final AtomicBoolean requestCommitted;
    private final AtomicBoolean done;
    private volatile boolean keepAlive;
    private volatile Timeout timeout;
    private volatile HttpRequest committedRequest;

    ClientHttp1StreamHandler(final Http1StreamChannel<HttpRequest> outputChannel, HttpProcessor httpProcessor, Http1Config http1Config, ConnectionReuseStrategy connectionReuseStrategy, AsyncClientExchangeHandler exchangeHandler, HttpCoreContext context) {
        this.outputChannel = outputChannel;
        this.internalDataChannel = new DataStreamChannel(){

            @Override
            public void requestOutput() {
                outputChannel.requestOutput();
            }

            @Override
            public void endStream(List<? extends Header> trailers) throws IOException {
                ClientHttp1StreamHandler.this.requestState.set(MessageState.COMPLETE);
                outputChannel.complete(trailers);
                if (!ClientHttp1StreamHandler.this.keepAlive && ClientHttp1StreamHandler.this.responseState.get() == MessageState.COMPLETE) {
                    outputChannel.close();
                }
            }

            @Override
            public int write(ByteBuffer src) throws IOException {
                return outputChannel.write(src);
            }

            @Override
            public void endStream() throws IOException {
                this.endStream(null);
            }
        };
        this.httpProcessor = httpProcessor;
        this.http1Config = http1Config;
        this.connectionReuseStrategy = connectionReuseStrategy;
        this.exchangeHandler = exchangeHandler;
        this.context = context;
        this.requestState = new AtomicReference<MessageState>(MessageState.IDLE);
        this.responseState = new AtomicReference<MessageState>(MessageState.HEADERS);
        this.requestCommitted = new AtomicBoolean();
        this.done = new AtomicBoolean();
        this.keepAlive = true;
    }

    boolean isRequestFinal() {
        return this.requestState.get() == MessageState.COMPLETE;
    }

    boolean isResponseFinal() {
        return this.responseState.get() == MessageState.COMPLETE;
    }

    boolean isCompleted() {
        return this.requestState.get() == MessageState.COMPLETE && this.responseState.get() == MessageState.COMPLETE;
    }

    String getRequestMethod() {
        return this.committedRequest != null ? this.committedRequest.getMethod() : null;
    }

    boolean isOutputReady() {
        switch (this.requestState.get()) {
            case IDLE: {
                return true;
            }
            case HEADERS: 
            case ACK: {
                return false;
            }
            case BODY: {
                return this.exchangeHandler.available() > 0;
            }
        }
        return false;
    }

    private void commitRequest(HttpRequest request, EntityDetails entityDetails) throws IOException, HttpException {
        if (this.requestCommitted.compareAndSet(false, true)) {
            boolean endStream;
            ProtocolVersion transportVersion = request.getVersion();
            if (transportVersion != null && !transportVersion.lessEquals(this.http1Config.getVersion())) {
                throw new UnsupportedHttpVersionException(transportVersion);
            }
            this.context.setProtocolVersion(transportVersion != null ? transportVersion : this.http1Config.getVersion());
            this.context.setRequest(request);
            this.httpProcessor.process(request, entityDetails, (HttpContext)this.context);
            boolean bl = endStream = entityDetails == null;
            if (endStream) {
                this.committedRequest = request;
                this.requestState.set(MessageState.COMPLETE);
                this.outputChannel.submit(request, true, FlushMode.IMMEDIATE);
            } else {
                Header h = request.getFirstHeader("Expect");
                boolean expectContinue = h != null && "100-continue".equalsIgnoreCase(h.getValue());
                this.outputChannel.submit(request, false, expectContinue ? FlushMode.IMMEDIATE : FlushMode.BUFFER);
                this.committedRequest = request;
                if (expectContinue) {
                    this.requestState.set(MessageState.ACK);
                    this.timeout = this.outputChannel.getSocketTimeout();
                    Timeout timeout = this.http1Config.getWaitForContinueTimeout() != null ? this.http1Config.getWaitForContinueTimeout() : DEFAULT_WAIT_FOR_CONTINUE;
                    this.outputChannel.setSocketTimeout(timeout);
                } else {
                    this.exchangeHandler.produce(this.internalDataChannel);
                    if (this.requestState.compareAndSet(MessageState.HEADERS, MessageState.BODY)) {
                        this.outputChannel.requestOutput();
                    }
                }
            }
        } else {
            throw new HttpException("Request already committed");
        }
    }

    void produceOutput() throws HttpException, IOException {
        switch (this.requestState.get()) {
            case IDLE: {
                this.requestState.set(MessageState.HEADERS);
                this.outputChannel.suspendOutput();
                this.exchangeHandler.produceRequest((request, entityDetails, httpContext) -> this.commitRequest(request, entityDetails), this.context);
                break;
            }
            case ACK: {
                this.outputChannel.suspendOutput();
                break;
            }
            case BODY: {
                this.exchangeHandler.produce(this.internalDataChannel);
            }
        }
    }

    void consumeHeader(HttpResponse response, EntityDetails entityDetails) throws HttpException, IOException {
        int status;
        if (this.done.get() || this.responseState.get() != MessageState.HEADERS) {
            throw new ProtocolException("Unexpected message head");
        }
        ProtocolVersion transportVersion = response.getVersion();
        if (transportVersion != null) {
            if (transportVersion.greaterEquals(HttpVersion.HTTP_2)) {
                throw new UnsupportedHttpVersionException(transportVersion);
            }
            this.context.setProtocolVersion(transportVersion);
        }
        if ((status = response.getCode()) < 100) {
            throw new ProtocolException("Invalid response: " + new StatusLine(response));
        }
        if (status > 100 && status < 200) {
            this.exchangeHandler.consumeInformation(response, this.context);
        } else if (!this.connectionReuseStrategy.keepAlive(this.committedRequest, response, this.context)) {
            this.keepAlive = false;
        }
        if (this.requestState.get() == MessageState.ACK && (status == 100 || status >= 200)) {
            this.outputChannel.setSocketTimeout(this.timeout);
            this.requestState.set(MessageState.BODY);
            if (status < 400) {
                this.exchangeHandler.produce(this.internalDataChannel);
            }
        }
        if (status < 200) {
            return;
        }
        if (this.requestState.get() == MessageState.BODY && status >= 400) {
            this.requestState.set(MessageState.COMPLETE);
            if (!this.outputChannel.abortGracefully()) {
                this.keepAlive = false;
            }
        }
        this.context.setProtocolVersion(transportVersion != null ? transportVersion : HttpVersion.HTTP_1_1);
        this.context.setResponse(response);
        this.httpProcessor.process(response, entityDetails, (HttpContext)this.context);
        if (entityDetails == null && !this.keepAlive) {
            this.outputChannel.close();
        }
        this.exchangeHandler.consumeResponse(response, entityDetails, this.context);
        this.responseState.set(entityDetails == null ? MessageState.COMPLETE : MessageState.BODY);
    }

    void consumeData(ByteBuffer src) throws HttpException, IOException {
        if (this.done.get() || this.responseState.get() != MessageState.BODY) {
            throw new ProtocolException("Unexpected message data");
        }
        this.exchangeHandler.consume(src);
    }

    void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        this.exchangeHandler.updateCapacity(capacityChannel);
    }

    void dataEnd(List<? extends Header> trailers) throws HttpException, IOException {
        if (this.done.get() || this.responseState.get() != MessageState.BODY) {
            throw new ProtocolException("Unexpected message data");
        }
        this.responseState.set(MessageState.COMPLETE);
        if (!this.keepAlive && this.requestState.get() == MessageState.COMPLETE) {
            this.outputChannel.close();
        }
        this.exchangeHandler.streamEnd(trailers);
    }

    boolean handleTimeout() {
        if (this.requestState.get() == MessageState.ACK) {
            this.requestState.set(MessageState.BODY);
            this.outputChannel.setSocketTimeout(this.timeout);
            this.outputChannel.requestOutput();
            return true;
        }
        return false;
    }

    void failed(Exception cause) {
        if (!this.done.get()) {
            this.exchangeHandler.failed(cause);
        }
    }

    @Override
    public void releaseResources() {
        if (this.done.compareAndSet(false, true)) {
            this.responseState.set(MessageState.COMPLETE);
            this.requestState.set(MessageState.COMPLETE);
            this.exchangeHandler.releaseResources();
        }
    }

    void appendState(StringBuilder buf) {
        buf.append("requestState=").append((Object)this.requestState.get()).append(", responseState=").append((Object)this.responseState.get()).append(", requestCommitted=").append(this.requestCommitted).append(", keepAlive=").append(this.keepAlive).append(", done=").append(this.done);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        this.appendState(buf);
        buf.append("]");
        return buf.toString();
    }
}

