/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.client5.http.impl.classic;

import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.client5.http.HttpRoute;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.client5.http.UserTokenHandler;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.client5.http.classic.ExecChain;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.client5.http.classic.ExecChainHandler;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.client5.http.classic.ExecRuntime;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.client5.http.impl.ConnectionShutdownException;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.client5.http.impl.ProtocolSwitchStrategy;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.client5.http.io.HttpClientConnectionManager;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.client5.http.protocol.HttpClientContext;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.annotation.Contract;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.annotation.Internal;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.ClassicHttpRequest;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.ClassicHttpResponse;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.ConnectionReuseStrategy;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.EntityDetails;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.HttpEntity;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.HttpException;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.ProtocolException;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.ProtocolVersion;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.protocol.HttpContext;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.protocol.HttpProcessor;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.io.CloseMode;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.util.Args;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.util.TimeValue;
import com.azure.security.keyvault.jca.implementation.shaded.org.slf4j.Logger;
import com.azure.security.keyvault.jca.implementation.shaded.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.InterruptedIOException;

@Contract(threading=ThreadingBehavior.STATELESS)
@Internal
public final class MainClientExec
implements ExecChainHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MainClientExec.class);
    private final HttpClientConnectionManager connectionManager;
    private final HttpProcessor httpProcessor;
    private final ConnectionReuseStrategy reuseStrategy;
    private final ConnectionKeepAliveStrategy keepAliveStrategy;
    private final UserTokenHandler userTokenHandler;
    private final ProtocolSwitchStrategy protocolSwitchStrategy;

    public MainClientExec(HttpClientConnectionManager connectionManager, HttpProcessor httpProcessor, ConnectionReuseStrategy reuseStrategy, ConnectionKeepAliveStrategy keepAliveStrategy, UserTokenHandler userTokenHandler) {
        this.connectionManager = Args.notNull(connectionManager, "Connection manager");
        this.httpProcessor = Args.notNull(httpProcessor, "HTTP protocol processor");
        this.reuseStrategy = Args.notNull(reuseStrategy, "Connection reuse strategy");
        this.keepAliveStrategy = Args.notNull(keepAliveStrategy, "Connection keep alive strategy");
        this.userTokenHandler = Args.notNull(userTokenHandler, "User token handler");
        this.protocolSwitchStrategy = new ProtocolSwitchStrategy();
    }

    @Override
    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        Args.notNull(request, "HTTP request");
        Args.notNull(scope, "Scope");
        String exchangeId = scope.exchangeId;
        HttpRoute route = scope.route;
        HttpClientContext context = scope.clientContext;
        ExecRuntime execRuntime = scope.execRuntime;
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} executing {} {}", exchangeId, request.getMethod(), request.getRequestUri());
        }
        try {
            context.setRoute(route);
            context.setRequest(request);
            this.httpProcessor.process(request, (EntityDetails)request.getEntity(), (HttpContext)context);
            ClassicHttpResponse response = execRuntime.execute(exchangeId, request, (r, connection, c) -> {
                if (r.getCode() == 101) {
                    ProtocolVersion upgradeProtocol = this.protocolSwitchStrategy.switchProtocol(r);
                    if (upgradeProtocol == null || !upgradeProtocol.getProtocol().equals("TLS")) {
                        throw new ProtocolException("Failure switching protocols");
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Switching to {}", (Object)upgradeProtocol);
                    }
                    try {
                        execRuntime.upgradeTls(context);
                    }
                    catch (IOException ex) {
                        throw new HttpException("Failure upgrading to TLS", ex);
                    }
                    LOG.debug("Successfully switched to {}", (Object)upgradeProtocol);
                }
            }, context);
            context.setResponse(response);
            this.httpProcessor.process(response, (EntityDetails)response.getEntity(), (HttpContext)context);
            Object userToken = context.getUserToken();
            if (userToken == null) {
                userToken = this.userTokenHandler.getUserToken(route, request, context);
                context.setUserToken(userToken);
            }
            if (this.reuseStrategy.keepAlive(request, response, context)) {
                TimeValue duration = this.keepAliveStrategy.getKeepAliveDuration(response, context);
                if (LOG.isDebugEnabled()) {
                    String s = duration != null ? "for " + duration : "indefinitely";
                    LOG.debug("{} connection can be kept alive {}", (Object)exchangeId, (Object)s);
                }
                execRuntime.markConnectionReusable(userToken, duration);
            } else {
                execRuntime.markConnectionNonReusable();
            }
            HttpEntity entity = response.getEntity();
            if (entity == null || !entity.isStreaming()) {
                execRuntime.releaseEndpoint();
                return new CloseableHttpResponse(response, null);
            }
            return new CloseableHttpResponse(response, execRuntime);
        }
        catch (ConnectionShutdownException ex) {
            InterruptedIOException ioex = new InterruptedIOException("Connection has been shut down");
            ioex.initCause(ex);
            execRuntime.discardEndpoint();
            throw ioex;
        }
        catch (HttpException | IOException | RuntimeException ex) {
            execRuntime.discardEndpoint();
            throw ex;
        }
        catch (Error error) {
            this.connectionManager.close(CloseMode.IMMEDIATE);
            throw error;
        }
    }
}

