/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca.implementation.model;

import com.azure.security.keyvault.jca.implementation.shaded.com.azure.json.JsonReader;
import com.azure.security.keyvault.jca.implementation.shaded.com.azure.json.JsonSerializable;
import com.azure.security.keyvault.jca.implementation.shaded.com.azure.json.JsonToken;
import com.azure.security.keyvault.jca.implementation.shaded.com.azure.json.JsonWriter;
import java.io.IOException;

public class SignResult
implements JsonSerializable<SignResult> {
    private String kid;
    private String value;

    public String getKid() {
        return this.kid;
    }

    public void setKid(String kid) {
        this.kid = kid;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kid", this.kid);
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    public static SignResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SignResult deserializedSignResult = new SignResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kid".equals(fieldName)) {
                    deserializedSignResult.kid = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedSignResult.value = SignResult.unquote(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSignResult;
        });
    }

    private static String unquote(String string) {
        int base64UrlStringLength;
        char lastCharacter;
        char firstCharacter;
        if (!(string == null || string.isEmpty() || (firstCharacter = string.charAt(0)) != '\"' && firstCharacter != '\'' || (lastCharacter = string.charAt((base64UrlStringLength = string.length()) - 1)) != firstCharacter)) {
            return string.substring(1, base64UrlStringLength - 1);
        }
        return string;
    }
}

