/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca.implementation.model;

import com.azure.security.keyvault.jca.implementation.shaded.com.azure.json.JsonReader;
import com.azure.security.keyvault.jca.implementation.shaded.com.azure.json.JsonSerializable;
import com.azure.security.keyvault.jca.implementation.shaded.com.azure.json.JsonToken;
import com.azure.security.keyvault.jca.implementation.shaded.com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

public class KeyProperties
implements JsonSerializable<KeyProperties> {
    private boolean exportable;
    private String kty;

    public String getKty() {
        return this.kty;
    }

    public void setKty(String kty) {
        this.kty = kty;
    }

    public boolean isExportable() {
        return this.exportable;
    }

    public void setExportable(boolean exportable) {
        this.exportable = exportable;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("exportable", this.exportable);
        jsonWriter.writeStringField("kty", Objects.toString(this.kty, null));
        return jsonWriter.writeEndObject();
    }

    public static KeyProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyProperties deserializedKeyProperties = new KeyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("exportable".equals(fieldName)) {
                    deserializedKeyProperties.exportable = reader.getBoolean();
                    continue;
                }
                if ("kty".equals(fieldName)) {
                    deserializedKeyProperties.kty = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyProperties;
        });
    }
}

