/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca;

import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;

public final class KeyVaultTrustManager
extends X509ExtendedTrustManager {
    private static final Logger LOGGER = Logger.getLogger(KeyVaultTrustManager.class.getName());
    private X509TrustManager defaultTrustManager;
    private KeyStore keyStore;

    public KeyVaultTrustManager() {
        this(null);
    }

    public KeyVaultTrustManager(KeyStore keyStore) {
        TrustManagerFactory factory;
        this.keyStore = keyStore;
        if (this.keyStore == null) {
            try {
                this.keyStore = KeyStore.getInstance("AzureKeyVault");
                this.keyStore.load(null, null);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
                LOGGER.log(Level.WARNING, "Unable to get AzureKeyVault keystore.", ex);
            }
        }
        try {
            factory = TrustManagerFactory.getInstance("PKIX", "SunJSSE");
            factory.init(keyStore);
            this.defaultTrustManager = (X509TrustManager)factory.getTrustManagers()[0];
        }
        catch (KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            LOGGER.log(Level.WARNING, "Unable to get the trust manager factory.", ex);
        }
        if (this.defaultTrustManager == null) {
            try {
                factory = TrustManagerFactory.getInstance("PKIX", "IbmJSSE");
                factory.init(keyStore);
                this.defaultTrustManager = (X509TrustManager)factory.getTrustManagers()[0];
            }
            catch (KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException ex) {
                LOGGER.log(Level.WARNING, "Unable to get the trust manager factory.", ex);
            }
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        boolean pass = true;
        try {
            this.defaultTrustManager.checkClientTrusted(chain, authType);
        }
        catch (CertificateException ce) {
            pass = false;
        }
        if (!pass) {
            String alias = null;
            try {
                alias = this.keyStore.getCertificateAlias(chain[0]);
            }
            catch (KeyStoreException kse) {
                LOGGER.log(Level.WARNING, "Unable to get the certificate in AzureKeyVault keystore.", kse);
            }
            if (alias == null) {
                throw new CertificateException("Unable to verify in keystore");
            }
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        boolean pass = true;
        try {
            this.defaultTrustManager.checkServerTrusted(chain, authType);
        }
        catch (CertificateException ce) {
            pass = false;
        }
        if (!pass) {
            String alias = null;
            try {
                alias = this.keyStore.getCertificateAlias(chain[0]);
            }
            catch (KeyStoreException kse) {
                LOGGER.log(Level.WARNING, "Unable to get the certificate in AzureKeyVault keystore.", kse);
            }
            if (alias == null) {
                throw new CertificateException("Unable to verify in keystore");
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.checkServerTrusted(chain, authType);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.checkServerTrusted(chain, authType);
    }
}

