/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca;

import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.X509ExtendedKeyManager;

public final class KeyVaultKeyManager
extends X509ExtendedKeyManager {
    private static final Logger LOGGER = Logger.getLogger(KeyVaultKeyManager.class.getName());
    private final KeyStore keystore;
    private final char[] password;

    public KeyVaultKeyManager(KeyStore keystore, char[] password) {
        LOGGER.entering("KeyVaultKeyManager", "<init>", new Object[]{keystore, password});
        this.keystore = keystore;
        if (password != null) {
            this.password = new char[password.length];
            System.arraycopy(password, 0, this.password, 0, password.length);
        } else {
            this.password = null;
        }
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        LOGGER.entering("KeyVaultKeyManager", "chooseClientAlias", new Object[]{keyType, issuers, socket});
        String alias = null;
        try {
            if (!this.keystore.getProvider().getName().equals("AzureKeyVault") && this.keystore.size() == 1) {
                alias = this.keystore.aliases().nextElement();
            }
        }
        catch (KeyStoreException kse) {
            LOGGER.log(Level.WARNING, "Unable to choose client alias", kse);
        }
        LOGGER.exiting("KeyVaultKeyManager", "chooseClientAlias", alias);
        return alias;
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        LOGGER.entering("KeyVaultKeyManager", "chooseServerAlias", new Object[]{keyType, issuers, socket});
        String alias = null;
        try {
            if (!this.keystore.getProvider().getName().equals("AzureKeyVault") && this.keystore.size() == 1) {
                alias = this.keystore.aliases().nextElement();
            }
        }
        catch (KeyStoreException kse) {
            LOGGER.log(Level.WARNING, "Unable to choose server alias", kse);
        }
        LOGGER.exiting("KeyVaultKeyManager", "chooseServerAlias", alias);
        return alias;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        LOGGER.log(Level.INFO, "KeyVaultKeyManager.getClientAliases: {0}, {1}", new Object[]{keyType, issuers});
        Object[] aliases = null;
        try {
            aliases = Collections.list(this.keystore.aliases()).toArray(new String[0]);
        }
        catch (KeyStoreException kse) {
            LOGGER.log(Level.WARNING, "Unable to get client aliases", kse);
        }
        LOGGER.log(Level.INFO, "KeyVaultKeyManager.getClientAliases: {0}", aliases);
        return aliases;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        LOGGER.entering("KeyVaultKeyManager", "getCertificateChain", alias);
        ArrayList<X509Certificate> chain = new ArrayList<X509Certificate>();
        try {
            Certificate[] keystoreChain = this.keystore.getCertificateChain(alias);
            if (keystoreChain.length > 0) {
                for (Certificate certificate : keystoreChain) {
                    if (!(certificate instanceof X509Certificate)) continue;
                    chain.add((X509Certificate)certificate);
                }
            } else {
                LOGGER.log(Level.WARNING, "No certificate chain found for alias: {0}", alias);
            }
        }
        catch (KeyStoreException kse) {
            LOGGER.log(Level.WARNING, "Unable to get certificate chain for alias: " + alias, kse);
        }
        LOGGER.exiting("KeyVaultKeyManager", "getCertificateChain", chain);
        return chain.toArray(new X509Certificate[0]);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        LOGGER.entering("KeyVaultKeyManager", "getPrivateKey", alias);
        PrivateKey privateKey = null;
        try {
            privateKey = (PrivateKey)this.keystore.getKey(alias, this.password);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException ex) {
            LOGGER.log(Level.WARNING, "Unable to get private key for alias: " + alias, ex);
        }
        LOGGER.exiting("KeyVaultKeyManager", "getPrivateKey", privateKey);
        return privateKey;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        LOGGER.entering("KeyVaultKeyManager", "getServerAliases", new Object[]{keyType, issuers});
        String[] serverAliases = new String[]{};
        try {
            serverAliases = Collections.list(this.keystore.aliases()).toArray(new String[0]);
        }
        catch (KeyStoreException kse) {
            LOGGER.log(Level.WARNING, "Unable to get server aliases", kse);
        }
        LOGGER.exiting("KeyVaultKeyManager", "getServerAliases", serverAliases);
        return serverAliases;
    }
}

