/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.certificates.implementation.CertificateIssuerHelper;
import com.azure.security.keyvault.certificates.implementation.CertificatesUtils;
import com.azure.security.keyvault.certificates.implementation.models.IssuerAttributes;
import com.azure.security.keyvault.certificates.implementation.models.IssuerBundle;
import com.azure.security.keyvault.certificates.implementation.models.IssuerCredentials;
import com.azure.security.keyvault.certificates.implementation.models.OrganizationDetails;
import com.azure.security.keyvault.certificates.models.AdministratorContact;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class CertificateIssuer
implements JsonSerializable<CertificateIssuer> {
    private static final ClientLogger LOGGER = new ClientLogger(CertificateIssuer.class);
    private final IssuerBundle issuerBundle;
    private final String name;

    public CertificateIssuer(String name, String provider) {
        this.name = name;
        this.issuerBundle = new IssuerBundle().setProvider(provider);
    }

    public CertificateIssuer(String name) {
        this(name, null);
    }

    private CertificateIssuer(IssuerBundle issuerBundle) {
        this.issuerBundle = issuerBundle;
        this.name = CertificatesUtils.getIdMetadata(issuerBundle.getId(), -1, 3, -1, LOGGER).getName();
    }

    public String getId() {
        return this.issuerBundle.getId();
    }

    public String getProvider() {
        return this.issuerBundle.getProvider();
    }

    public String getName() {
        return this.name;
    }

    public String getAccountId() {
        return this.issuerBundle.getCredentials() == null ? null : this.issuerBundle.getCredentials().getAccountId();
    }

    public CertificateIssuer setAccountId(String accountId) {
        if (this.issuerBundle.getCredentials() == null) {
            this.issuerBundle.setCredentials(new IssuerCredentials());
        }
        this.issuerBundle.getCredentials().setAccountId(accountId);
        return this;
    }

    public String getPassword() {
        return this.issuerBundle.getCredentials() == null ? null : this.issuerBundle.getCredentials().getPassword();
    }

    public CertificateIssuer setPassword(String password) {
        if (this.issuerBundle.getCredentials() == null) {
            this.issuerBundle.setCredentials(new IssuerCredentials());
        }
        this.issuerBundle.getCredentials().setPassword(password);
        return this;
    }

    public String getOrganizationId() {
        return this.issuerBundle.getOrganizationDetails() == null ? null : this.issuerBundle.getOrganizationDetails().getId();
    }

    public CertificateIssuer setOrganizationId(String organizationId) {
        if (this.issuerBundle.getOrganizationDetails() == null) {
            this.issuerBundle.setOrganizationDetails(new OrganizationDetails());
        }
        this.issuerBundle.getOrganizationDetails().setId(organizationId);
        return this;
    }

    public List<AdministratorContact> getAdministratorContacts() {
        return this.issuerBundle.getOrganizationDetails() == null ? null : this.issuerBundle.getOrganizationDetails().getAdminDetails();
    }

    public CertificateIssuer setAdministratorContacts(List<AdministratorContact> administratorContacts) {
        if (this.issuerBundle.getOrganizationDetails() == null) {
            this.issuerBundle.setOrganizationDetails(new OrganizationDetails());
        }
        this.issuerBundle.getOrganizationDetails().setAdminDetails(administratorContacts);
        return this;
    }

    public Boolean isEnabled() {
        return this.issuerBundle.getAttributes() == null ? null : this.issuerBundle.getAttributes().isEnabled();
    }

    public CertificateIssuer setEnabled(Boolean enabled) {
        if (this.issuerBundle.getAttributes() == null) {
            this.issuerBundle.setAttributes(new IssuerAttributes());
        }
        this.issuerBundle.getAttributes().setEnabled(enabled);
        return this;
    }

    public OffsetDateTime getCreatedOn() {
        return this.issuerBundle.getAttributes() == null ? null : this.issuerBundle.getAttributes().getCreated();
    }

    public OffsetDateTime getUpdatedOn() {
        return this.issuerBundle.getAttributes() == null ? null : this.issuerBundle.getAttributes().getUpdated();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return this.issuerBundle.toJson(jsonWriter);
    }

    public static CertificateIssuer fromJson(JsonReader jsonReader) throws IOException {
        return new CertificateIssuer(IssuerBundle.fromJson(jsonReader));
    }

    static {
        CertificateIssuerHelper.setAccessor(new CertificateIssuerHelper.CertificateIssuerAccessor(){

            @Override
            public CertificateIssuer createCertificateIssuer(IssuerBundle issuerBundle) {
                return new CertificateIssuer(issuerBundle);
            }

            @Override
            public IssuerBundle getIssuerBundle(CertificateIssuer certificateIssuer) {
                return certificateIssuer.issuerBundle;
            }
        });
    }
}

