/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.certificates.implementation.models.CertificateAttributes;
import com.azure.security.keyvault.certificates.implementation.models.CertificatePolicy;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;

public final class DeletedCertificateBundle
implements JsonSerializable<DeletedCertificateBundle> {
    private String id;
    private String kid;
    private String sid;
    private Base64Url x509Thumbprint;
    private CertificatePolicy policy;
    private byte[] cer;
    private String contentType;
    private CertificateAttributes attributes;
    private Map<String, String> tags;
    private Boolean preserveCertOrder;
    private String recoveryId;
    private Long scheduledPurgeDate;
    private Long deletedDate;

    private DeletedCertificateBundle() {
    }

    public String getId() {
        return this.id;
    }

    public String getKid() {
        return this.kid;
    }

    public String getSid() {
        return this.sid;
    }

    public byte[] getX509Thumbprint() {
        if (this.x509Thumbprint == null) {
            return null;
        }
        return this.x509Thumbprint.decodedBytes();
    }

    public CertificatePolicy getPolicy() {
        return this.policy;
    }

    public byte[] getCer() {
        return CoreUtils.clone((byte[])this.cer);
    }

    public String getContentType() {
        return this.contentType;
    }

    public CertificateAttributes getAttributes() {
        return this.attributes;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Boolean isPreserveCertOrder() {
        return this.preserveCertOrder;
    }

    public String getRecoveryId() {
        return this.recoveryId;
    }

    public OffsetDateTime getScheduledPurgeDate() {
        if (this.scheduledPurgeDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.scheduledPurgeDate), ZoneOffset.UTC);
    }

    public OffsetDateTime getDeletedDate() {
        if (this.deletedDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.deletedDate), ZoneOffset.UTC);
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBinaryField("cer", this.cer);
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeJsonField("attributes", (JsonSerializable)this.attributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("preserveCertOrder", this.preserveCertOrder);
        jsonWriter.writeStringField("recoveryId", this.recoveryId);
        return jsonWriter.writeEndObject();
    }

    public static DeletedCertificateBundle fromJson(JsonReader jsonReader) throws IOException {
        return (DeletedCertificateBundle)jsonReader.readObject(reader -> {
            DeletedCertificateBundle deserializedDeletedCertificateBundle = new DeletedCertificateBundle();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.id = reader.getString();
                    continue;
                }
                if ("kid".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.kid = reader.getString();
                    continue;
                }
                if ("sid".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.sid = reader.getString();
                    continue;
                }
                if ("x5t".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.x509Thumbprint = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.policy = CertificatePolicy.fromJson(reader);
                    continue;
                }
                if ("cer".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.cer = reader.getBinary();
                    continue;
                }
                if ("contentType".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.contentType = reader.getString();
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.attributes = CertificateAttributes.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedDeletedCertificateBundle.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("preserveCertOrder".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.preserveCertOrder = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("recoveryId".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.recoveryId = reader.getString();
                    continue;
                }
                if ("scheduledPurgeDate".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.scheduledPurgeDate = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("deletedDate".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.deletedDate = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeletedCertificateBundle;
        });
    }
}

