/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.core.util.Base64Url;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.certificates.implementation.models.CertificateAttributes;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

public final class CertificateItem
implements JsonSerializable<CertificateItem> {
    private String id;
    private CertificateAttributes attributes;
    private Map<String, String> tags;
    private Base64Url x509Thumbprint;

    private CertificateItem() {
    }

    public String getId() {
        return this.id;
    }

    public CertificateAttributes getAttributes() {
        return this.attributes;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public byte[] getX509Thumbprint() {
        if (this.x509Thumbprint == null) {
            return null;
        }
        return this.x509Thumbprint.decodedBytes();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("attributes", (JsonSerializable)this.attributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("x5t", Objects.toString(this.x509Thumbprint, null));
        return jsonWriter.writeEndObject();
    }

    public static CertificateItem fromJson(JsonReader jsonReader) throws IOException {
        return (CertificateItem)jsonReader.readObject(reader -> {
            CertificateItem deserializedCertificateItem = new CertificateItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCertificateItem.id = reader.getString();
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    deserializedCertificateItem.attributes = CertificateAttributes.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedCertificateItem.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("x5t".equals(fieldName)) {
                    deserializedCertificateItem.x509Thumbprint = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCertificateItem;
        });
    }
}

