/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.certificates.implementation.models.CertificateAttributes;
import com.azure.security.keyvault.certificates.implementation.models.CertificatePolicy;
import java.io.IOException;
import java.util.Map;

public final class CertificateImportParameters
implements JsonSerializable<CertificateImportParameters> {
    private final String base64EncodedCertificate;
    private String password;
    private CertificatePolicy certificatePolicy;
    private CertificateAttributes certificateAttributes;
    private Map<String, String> tags;
    private Boolean preserveCertOrder;

    public CertificateImportParameters(String base64EncodedCertificate) {
        this.base64EncodedCertificate = base64EncodedCertificate;
    }

    public String getBase64EncodedCertificate() {
        return this.base64EncodedCertificate;
    }

    public String getPassword() {
        return this.password;
    }

    public CertificateImportParameters setPassword(String password) {
        this.password = password;
        return this;
    }

    public CertificatePolicy getCertificatePolicy() {
        return this.certificatePolicy;
    }

    public CertificateImportParameters setCertificatePolicy(CertificatePolicy certificatePolicy) {
        this.certificatePolicy = certificatePolicy;
        return this;
    }

    public CertificateAttributes getCertificateAttributes() {
        return this.certificateAttributes;
    }

    public CertificateImportParameters setCertificateAttributes(CertificateAttributes certificateAttributes) {
        this.certificateAttributes = certificateAttributes;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public CertificateImportParameters setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Boolean isPreserveCertOrder() {
        return this.preserveCertOrder;
    }

    public CertificateImportParameters setPreserveCertOrder(Boolean preserveCertOrder) {
        this.preserveCertOrder = preserveCertOrder;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.base64EncodedCertificate);
        jsonWriter.writeStringField("pwd", this.password);
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.certificatePolicy);
        jsonWriter.writeJsonField("attributes", (JsonSerializable)this.certificateAttributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("preserveCertOrder", this.preserveCertOrder);
        return jsonWriter.writeEndObject();
    }

    public static CertificateImportParameters fromJson(JsonReader jsonReader) throws IOException {
        return (CertificateImportParameters)jsonReader.readObject(reader -> {
            String base64EncodedCertificate = null;
            String password = null;
            CertificatePolicy certificatePolicy = null;
            CertificateAttributes certificateAttributes = null;
            Map tags = null;
            Boolean preserveCertOrder = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    base64EncodedCertificate = reader.getString();
                    continue;
                }
                if ("pwd".equals(fieldName)) {
                    password = reader.getString();
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    certificatePolicy = CertificatePolicy.fromJson(reader);
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    certificateAttributes = CertificateAttributes.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("preserveCertOrder".equals(fieldName)) {
                    preserveCertOrder = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            CertificateImportParameters deserializedCertificateImportParameters = new CertificateImportParameters(base64EncodedCertificate);
            deserializedCertificateImportParameters.password = password;
            deserializedCertificateImportParameters.certificatePolicy = certificatePolicy;
            deserializedCertificateImportParameters.certificateAttributes = certificateAttributes;
            deserializedCertificateImportParameters.tags = tags;
            deserializedCertificateImportParameters.preserveCertOrder = preserveCertOrder;
            return deserializedCertificateImportParameters;
        });
    }
}

