/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import com.azure.core.util.polling.SyncPoller;
import com.azure.security.keyvault.certificates.CertificateAsyncClient;
import com.azure.security.keyvault.certificates.CertificateClientBuilder;
import com.azure.security.keyvault.certificates.implementation.CertificateClientImpl;
import com.azure.security.keyvault.certificates.implementation.CertificateIssuerHelper;
import com.azure.security.keyvault.certificates.implementation.CertificateOperationHelper;
import com.azure.security.keyvault.certificates.implementation.CertificatePolicyHelper;
import com.azure.security.keyvault.certificates.implementation.CertificatePropertiesHelper;
import com.azure.security.keyvault.certificates.implementation.DeletedCertificateHelper;
import com.azure.security.keyvault.certificates.implementation.KeyVaultCertificateWithPolicyHelper;
import com.azure.security.keyvault.certificates.implementation.models.BackupCertificateResult;
import com.azure.security.keyvault.certificates.implementation.models.CertificateAttributes;
import com.azure.security.keyvault.certificates.implementation.models.CertificateBundle;
import com.azure.security.keyvault.certificates.implementation.models.CertificateCreateParameters;
import com.azure.security.keyvault.certificates.implementation.models.CertificateImportParameters;
import com.azure.security.keyvault.certificates.implementation.models.CertificateIssuerSetParameters;
import com.azure.security.keyvault.certificates.implementation.models.CertificateIssuerUpdateParameters;
import com.azure.security.keyvault.certificates.implementation.models.CertificateItem;
import com.azure.security.keyvault.certificates.implementation.models.CertificateMergeParameters;
import com.azure.security.keyvault.certificates.implementation.models.CertificateOperationUpdateParameter;
import com.azure.security.keyvault.certificates.implementation.models.CertificateRestoreParameters;
import com.azure.security.keyvault.certificates.implementation.models.CertificateUpdateParameters;
import com.azure.security.keyvault.certificates.implementation.models.Contacts;
import com.azure.security.keyvault.certificates.implementation.models.DeletedCertificateBundle;
import com.azure.security.keyvault.certificates.implementation.models.DeletedCertificateItem;
import com.azure.security.keyvault.certificates.implementation.models.IssuerBundle;
import com.azure.security.keyvault.certificates.models.CertificateContact;
import com.azure.security.keyvault.certificates.models.CertificateIssuer;
import com.azure.security.keyvault.certificates.models.CertificateOperation;
import com.azure.security.keyvault.certificates.models.CertificatePolicy;
import com.azure.security.keyvault.certificates.models.CertificateProperties;
import com.azure.security.keyvault.certificates.models.CreateCertificateOptions;
import com.azure.security.keyvault.certificates.models.DeletedCertificate;
import com.azure.security.keyvault.certificates.models.ImportCertificateOptions;
import com.azure.security.keyvault.certificates.models.IssuerProperties;
import com.azure.security.keyvault.certificates.models.KeyVaultCertificate;
import com.azure.security.keyvault.certificates.models.KeyVaultCertificateWithPolicy;
import com.azure.security.keyvault.certificates.models.MergeCertificateOptions;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

@ServiceClient(builder=CertificateClientBuilder.class, serviceInterfaces={CertificateClientImpl.CertificateClientService.class})
public final class CertificateClient {
    private static final ClientLogger LOGGER = new ClientLogger(CertificateClient.class);
    private final CertificateClientImpl implClient;
    private final String vaultUrl;

    CertificateClient(CertificateClientImpl implClient, String vaultUrl) {
        this.implClient = implClient;
        this.vaultUrl = vaultUrl;
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<CertificateOperation, KeyVaultCertificateWithPolicy> beginCreateCertificate(String certificateName, CertificatePolicy certificatePolicy) {
        return this.beginCreateCertificate(certificateName, certificatePolicy, true, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<CertificateOperation, KeyVaultCertificateWithPolicy> beginCreateCertificate(String certificateName, CertificatePolicy certificatePolicy, Boolean isEnabled, Map<String, String> tags) {
        return this.beginCreateCertificate(new CreateCertificateOptions(certificateName, certificatePolicy).setEnabled(isEnabled).setTags(tags).setCertificateOrderPreserved(false));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<CertificateOperation, KeyVaultCertificateWithPolicy> beginCreateCertificate(CreateCertificateOptions createCertificateOptions) {
        if (createCertificateOptions == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'createCertificateOptions' cannot be null."));
        }
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), ignored -> this.createCertificateActivation(createCertificateOptions.getName(), createCertificateOptions.getPolicy(), createCertificateOptions.isEnabled(), createCertificateOptions.getTags(), createCertificateOptions.isCertificateOrderPreserved()), ignored -> this.certificatePollOperation(createCertificateOptions.getName()), (ignored1, ignored2) -> this.certificateCancellationOperation(createCertificateOptions.getName()), ignored -> this.fetchCertificateOperation(createCertificateOptions.getName()));
    }

    private PollResponse<CertificateOperation> createCertificateActivation(String certificateName, CertificatePolicy certificatePolicy, Boolean isEnabled, Map<String, String> tags, Boolean preserveCertificateOrder) {
        CertificateCreateParameters certificateCreateParameters = new CertificateCreateParameters().setCertificatePolicy(CertificatePolicyHelper.getImplCertificatePolicy(certificatePolicy)).setCertificateAttributes(new CertificateAttributes().setEnabled(isEnabled)).setTags(tags).setPreserveCertOrder(preserveCertificateOrder);
        return new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)CertificateOperationHelper.createCertificateOperation(CertificateClient.callWithMappedException(() -> (com.azure.security.keyvault.certificates.implementation.models.CertificateOperation)((BinaryData)this.implClient.createCertificateWithResponse(certificateName, BinaryData.fromObject((Object)certificateCreateParameters), CertificateAsyncClient.EMPTY_OPTIONS).getValue()).toObject(com.azure.security.keyvault.certificates.implementation.models.CertificateOperation.class), CertificateAsyncClient::mapCreateCertificateException)));
    }

    private PollResponse<CertificateOperation> certificatePollOperation(String certificateName) {
        return CertificateAsyncClient.processCertificateOperationResponse(CertificateClient.callWithMappedException(() -> (com.azure.security.keyvault.certificates.implementation.models.CertificateOperation)((BinaryData)this.implClient.getCertificateOperationWithResponse(certificateName, CertificateAsyncClient.EMPTY_OPTIONS).getValue()).toObject(com.azure.security.keyvault.certificates.implementation.models.CertificateOperation.class), CertificateAsyncClient::mapGetCertificateOperationException));
    }

    private CertificateOperation certificateCancellationOperation(String certificateName) {
        CertificateOperationUpdateParameter certificateOperationUpdateParameter = new CertificateOperationUpdateParameter(true);
        return CertificateOperationHelper.createCertificateOperation(CertificateClient.callWithMappedException(() -> (com.azure.security.keyvault.certificates.implementation.models.CertificateOperation)((BinaryData)this.implClient.updateCertificateOperationWithResponse(certificateName, BinaryData.fromObject((Object)certificateOperationUpdateParameter), CertificateAsyncClient.EMPTY_OPTIONS).getValue()).toObject(com.azure.security.keyvault.certificates.implementation.models.CertificateOperation.class), CertificateAsyncClient::mapUpdateCertificateOperationException));
    }

    private KeyVaultCertificateWithPolicy fetchCertificateOperation(String certificateName) {
        return KeyVaultCertificateWithPolicyHelper.createCertificateWithPolicy(CertificateClient.callWithMappedException(() -> (CertificateBundle)((BinaryData)this.implClient.getCertificateWithResponse(certificateName, null, CertificateAsyncClient.EMPTY_OPTIONS).getValue()).toObject(CertificateBundle.class), CertificateAsyncClient::mapGetCertificateException));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<CertificateOperation, KeyVaultCertificateWithPolicy> getCertificateOperation(String certificateName) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), ignored -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, null), ignored -> this.certificatePollOperation(certificateName), (ignored1, ignored2) -> this.certificateCancellationOperation(certificateName), ignored -> this.fetchCertificateOperation(certificateName));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultCertificateWithPolicy getCertificate(String certificateName) {
        return (KeyVaultCertificateWithPolicy)this.getCertificateWithResponse(certificateName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultCertificateWithPolicy> getCertificateWithResponse(String certificateName, Context context) {
        return CertificateClient.callWithMappedResponseAndException(() -> this.implClient.getCertificateWithResponse(certificateName, null, new RequestOptions().setContext(context)), binaryData -> KeyVaultCertificateWithPolicyHelper.createCertificateWithPolicy((CertificateBundle)binaryData.toObject(CertificateBundle.class)), CertificateAsyncClient::mapGetCertificateException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultCertificate> getCertificateVersionWithResponse(String certificateName, String version, Context context) {
        return CertificateClient.callWithMappedResponseAndException(() -> this.implClient.getCertificateWithResponse(certificateName, version, new RequestOptions().setContext(context)), binaryData -> KeyVaultCertificateWithPolicyHelper.createCertificateWithPolicy((CertificateBundle)binaryData.toObject(CertificateBundle.class)), CertificateAsyncClient::mapGetCertificateException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultCertificate getCertificateVersion(String certificateName, String version) {
        return (KeyVaultCertificate)this.getCertificateVersionWithResponse(certificateName, version, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultCertificate updateCertificateProperties(CertificateProperties properties) {
        return (KeyVaultCertificate)this.updateCertificatePropertiesWithResponse(properties, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultCertificate> updateCertificatePropertiesWithResponse(CertificateProperties properties, Context context) {
        if (properties == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'properties' cannot be null."));
        }
        CertificateAttributes certificateAttributes = new CertificateAttributes().setEnabled(properties.isEnabled()).setExpires(properties.getExpiresOn()).setNotBefore(properties.getNotBefore());
        CertificateUpdateParameters certificateUpdateParameters = new CertificateUpdateParameters().setCertificateAttributes(certificateAttributes).setTags(properties.getTags());
        Response<BinaryData> response = this.implClient.updateCertificateWithResponse(properties.getName(), properties.getVersion(), BinaryData.fromObject((Object)certificateUpdateParameters), new RequestOptions().setContext(context));
        return new SimpleResponse(response, (Object)KeyVaultCertificateWithPolicyHelper.createCertificateWithPolicy((CertificateBundle)((BinaryData)response.getValue()).toObject(CertificateBundle.class)));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DeletedCertificate, Void> beginDeleteCertificate(String certificateName) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), ignored -> this.deleteCertificateActivation(certificateName), pollingContext -> this.deleteCertificatePollOperation(certificateName, (PollingContext<DeletedCertificate>)pollingContext), (pollingContext, firstResponse) -> null, pollingContext -> null);
    }

    private PollResponse<DeletedCertificate> deleteCertificateActivation(String certificateName) {
        return new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)DeletedCertificateHelper.createDeletedCertificate(CertificateClient.callWithMappedException(() -> (DeletedCertificateBundle)((BinaryData)this.implClient.deleteCertificateWithResponse(certificateName, CertificateAsyncClient.EMPTY_OPTIONS).getValue()).toObject(DeletedCertificateBundle.class), CertificateAsyncClient::mapDeleteCertificateException)));
    }

    private PollResponse<DeletedCertificate> deleteCertificatePollOperation(String certificateName, PollingContext<DeletedCertificate> pollingContext) {
        try {
            return new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)DeletedCertificateHelper.createDeletedCertificate((DeletedCertificateBundle)((BinaryData)this.implClient.getDeletedCertificateWithResponse(certificateName, CertificateAsyncClient.EMPTY_OPTIONS).getValue()).toObject(DeletedCertificateBundle.class)));
        }
        catch (HttpResponseException e) {
            if (e.getResponse().getStatusCode() == 404) {
                return new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((DeletedCertificate)pollingContext.getLatestResponse().getValue()));
            }
            return new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedCertificate)pollingContext.getLatestResponse().getValue()));
        }
        catch (Exception e) {
            return new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedCertificate)pollingContext.getLatestResponse().getValue()));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeletedCertificate getDeletedCertificate(String certificateName) {
        return (DeletedCertificate)this.getDeletedCertificateWithResponse(certificateName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeletedCertificate> getDeletedCertificateWithResponse(String certificateName, Context context) {
        Response<BinaryData> response = this.implClient.getDeletedCertificateWithResponse(certificateName, new RequestOptions().setContext(context));
        return new SimpleResponse(response, (Object)DeletedCertificateHelper.createDeletedCertificate((DeletedCertificateBundle)((BinaryData)response.getValue()).toObject(DeletedCertificateBundle.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void purgeDeletedCertificate(String certificateName) {
        this.purgeDeletedCertificateWithResponse(certificateName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> purgeDeletedCertificateWithResponse(String certificateName, Context context) {
        return this.implClient.purgeDeletedCertificateWithResponse(certificateName, new RequestOptions().setContext(context));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<KeyVaultCertificateWithPolicy, Void> beginRecoverDeletedCertificate(String certificateName) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), ignored -> this.recoverDeletedCertificateActivation(certificateName), pollingContext -> this.recoverDeletedCertificatePollOperation(certificateName, (PollingContext<KeyVaultCertificateWithPolicy>)pollingContext), (pollingContext, firstResponse) -> null, pollingContext -> null);
    }

    private PollResponse<KeyVaultCertificateWithPolicy> recoverDeletedCertificateActivation(String certificateName) {
        return new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)KeyVaultCertificateWithPolicyHelper.createCertificateWithPolicy((CertificateBundle)((BinaryData)this.implClient.recoverDeletedCertificateWithResponse(certificateName, CertificateAsyncClient.EMPTY_OPTIONS).getValue()).toObject(CertificateBundle.class)));
    }

    private PollResponse<KeyVaultCertificateWithPolicy> recoverDeletedCertificatePollOperation(String certificateName, PollingContext<KeyVaultCertificateWithPolicy> pollingContext) {
        try {
            return new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)KeyVaultCertificateWithPolicyHelper.createCertificateWithPolicy((CertificateBundle)((BinaryData)this.implClient.getCertificateWithResponse(certificateName, null, CertificateAsyncClient.EMPTY_OPTIONS).getValue()).toObject(CertificateBundle.class)));
        }
        catch (HttpResponseException e) {
            if (e.getResponse().getStatusCode() == 404) {
                return new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((KeyVaultCertificateWithPolicy)pollingContext.getLatestResponse().getValue()));
            }
            return new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultCertificateWithPolicy)pollingContext.getLatestResponse().getValue()));
        }
        catch (Exception e) {
            return new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultCertificateWithPolicy)pollingContext.getLatestResponse().getValue()));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public byte[] backupCertificate(String certificateName) {
        return (byte[])this.backupCertificateWithResponse(certificateName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<byte[]> backupCertificateWithResponse(String certificateName, Context context) {
        Response<BinaryData> response = this.implClient.backupCertificateWithResponse(certificateName, new RequestOptions().setContext(context));
        return new SimpleResponse(response, (Object)((BackupCertificateResult)((BinaryData)response.getValue()).toObject(BackupCertificateResult.class)).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultCertificateWithPolicy restoreCertificateBackup(byte[] backup) {
        return (KeyVaultCertificateWithPolicy)this.restoreCertificateBackupWithResponse(backup, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultCertificateWithPolicy> restoreCertificateBackupWithResponse(byte[] backup, Context context) {
        CertificateRestoreParameters certificateRestoreParameters = new CertificateRestoreParameters(backup);
        return CertificateClient.callWithMappedResponseAndException(() -> this.implClient.restoreCertificateWithResponse(BinaryData.fromObject((Object)certificateRestoreParameters), new RequestOptions().setContext(context)), binaryData -> KeyVaultCertificateWithPolicyHelper.createCertificateWithPolicy((CertificateBundle)binaryData.toObject(CertificateBundle.class)), CertificateAsyncClient::mapRestoreCertificateException);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateProperties> listPropertiesOfCertificates() {
        return this.listPropertiesOfCertificates(false, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateProperties> listPropertiesOfCertificates(boolean includePending, Context context) {
        RequestOptions requestOptions = new RequestOptions().setContext(context).addQueryParam("includePending", String.valueOf(includePending), false);
        return this.implClient.getCertificates(requestOptions).mapPage(binaryData -> CertificatePropertiesHelper.createCertificateProperties((CertificateItem)binaryData.toObject(CertificateItem.class)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeletedCertificate> listDeletedCertificates() {
        return this.listDeletedCertificates(false, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeletedCertificate> listDeletedCertificates(boolean includePending, Context context) {
        RequestOptions requestOptions = new RequestOptions().setContext(context).addQueryParam("includePending", String.valueOf(includePending), false);
        return this.implClient.getDeletedCertificates(requestOptions).mapPage(binaryData -> DeletedCertificateHelper.createDeletedCertificate((DeletedCertificateItem)binaryData.toObject(DeletedCertificateItem.class)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateProperties> listPropertiesOfCertificateVersions(String certificateName) {
        return this.listPropertiesOfCertificateVersions(certificateName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateProperties> listPropertiesOfCertificateVersions(String certificateName, Context context) {
        return this.implClient.getCertificateVersions(certificateName, new RequestOptions().setContext(context)).mapPage(binaryData -> CertificatePropertiesHelper.createCertificateProperties((CertificateItem)binaryData.toObject(CertificateItem.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificatePolicy getCertificatePolicy(String certificateName) {
        return (CertificatePolicy)this.getCertificatePolicyWithResponse(certificateName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificatePolicy> getCertificatePolicyWithResponse(String certificateName, Context context) {
        return CertificateClient.callWithMappedResponseAndException(() -> this.implClient.getCertificatePolicyWithResponse(certificateName, new RequestOptions().setContext(context)), binaryData -> CertificatePolicyHelper.createCertificatePolicy((com.azure.security.keyvault.certificates.implementation.models.CertificatePolicy)binaryData.toObject(com.azure.security.keyvault.certificates.implementation.models.CertificatePolicy.class)), CertificateAsyncClient::mapGetCertificatePolicyException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificatePolicy updateCertificatePolicy(String certificateName, CertificatePolicy certificatePolicy) {
        return (CertificatePolicy)this.updateCertificatePolicyWithResponse(certificateName, certificatePolicy, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificatePolicy> updateCertificatePolicyWithResponse(String certificateName, CertificatePolicy certificatePolicy, Context context) {
        if (certificatePolicy == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'certificatePolicy' cannot be null."));
        }
        Response<BinaryData> response = this.implClient.updateCertificatePolicyWithResponse(certificateName, BinaryData.fromObject((Object)CertificatePolicyHelper.getImplCertificatePolicy(certificatePolicy)), new RequestOptions().setContext(context));
        return new SimpleResponse(response, (Object)CertificatePolicyHelper.createCertificatePolicy((com.azure.security.keyvault.certificates.implementation.models.CertificatePolicy)((BinaryData)response.getValue()).toObject(com.azure.security.keyvault.certificates.implementation.models.CertificatePolicy.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateIssuer createIssuer(CertificateIssuer issuer) {
        return (CertificateIssuer)this.createIssuerWithResponse(issuer, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateIssuer> createIssuerWithResponse(CertificateIssuer issuer, Context context) {
        if (issuer == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'issuer' cannot be null."));
        }
        IssuerBundle issuerBundle = CertificateIssuerHelper.getIssuerBundle(issuer);
        CertificateIssuerSetParameters certificateIssuerSetParameters = new CertificateIssuerSetParameters(issuerBundle.getProvider()).setOrganizationDetails(issuerBundle.getOrganizationDetails()).setCredentials(issuerBundle.getCredentials()).setAttributes(issuerBundle.getAttributes());
        Response<BinaryData> response = this.implClient.setCertificateIssuerWithResponse(issuer.getName(), BinaryData.fromObject((Object)certificateIssuerSetParameters), new RequestOptions().setContext(context));
        return new SimpleResponse(response, (Object)CertificateIssuerHelper.createCertificateIssuer((IssuerBundle)((BinaryData)response.getValue()).toObject(IssuerBundle.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateIssuer> getIssuerWithResponse(String issuerName, Context context) {
        Response<BinaryData> response = this.implClient.getCertificateIssuerWithResponse(issuerName, new RequestOptions().setContext(context));
        return new SimpleResponse(response, (Object)CertificateIssuerHelper.createCertificateIssuer((IssuerBundle)((BinaryData)response.getValue()).toObject(IssuerBundle.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateIssuer getIssuer(String issuerName) {
        return (CertificateIssuer)this.getIssuerWithResponse(issuerName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateIssuer> deleteIssuerWithResponse(String issuerName, Context context) {
        Response<BinaryData> response = this.implClient.deleteCertificateIssuerWithResponse(issuerName, new RequestOptions().setContext(context));
        return new SimpleResponse(response, (Object)CertificateIssuerHelper.createCertificateIssuer((IssuerBundle)((BinaryData)response.getValue()).toObject(IssuerBundle.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateIssuer deleteIssuer(String issuerName) {
        return (CertificateIssuer)this.deleteIssuerWithResponse(issuerName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<IssuerProperties> listPropertiesOfIssuers() {
        return this.listPropertiesOfIssuers(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<IssuerProperties> listPropertiesOfIssuers(Context context) {
        return this.implClient.getCertificateIssuers(new RequestOptions().setContext(context)).mapPage(issuer -> (IssuerProperties)issuer.toObject(IssuerProperties.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateIssuer updateIssuer(CertificateIssuer issuer) {
        return (CertificateIssuer)this.updateIssuerWithResponse(issuer, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateIssuer> updateIssuerWithResponse(CertificateIssuer issuer, Context context) {
        if (issuer == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'issuer' cannot be null."));
        }
        IssuerBundle issuerBundle = CertificateIssuerHelper.getIssuerBundle(issuer);
        CertificateIssuerUpdateParameters certificateIssuerUpdateParameters = new CertificateIssuerUpdateParameters().setProvider(issuerBundle.getProvider()).setAttributes(issuerBundle.getAttributes()).setCredentials(issuerBundle.getCredentials()).setOrganizationDetails(issuerBundle.getOrganizationDetails());
        Response<BinaryData> response = this.implClient.updateCertificateIssuerWithResponse(issuer.getName(), BinaryData.fromObject((Object)certificateIssuerUpdateParameters), new RequestOptions().setContext(context));
        return new SimpleResponse(response, (Object)CertificateIssuerHelper.createCertificateIssuer((IssuerBundle)((BinaryData)response.getValue()).toObject(IssuerBundle.class)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateContact> setContacts(List<CertificateContact> contacts) {
        return this.setContacts(contacts, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateContact> setContacts(List<CertificateContact> contacts, Context context) {
        return new PagedIterable(() -> CertificateAsyncClient.mapContactsToPagedResponse(this.implClient.setCertificateContactsWithResponse(BinaryData.fromObject((Object)new Contacts().setContactList(contacts)), new RequestOptions().setContext(context))));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateContact> listContacts() {
        return this.listContacts(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateContact> listContacts(Context context) {
        return new PagedIterable(() -> CertificateAsyncClient.mapContactsToPagedResponse(this.implClient.getCertificateContactsWithResponse(new RequestOptions().setContext(context))));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateContact> deleteContacts() {
        return this.deleteContacts(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateContact> deleteContacts(Context context) {
        return new PagedIterable(() -> CertificateAsyncClient.mapContactsToPagedResponse(this.implClient.deleteCertificateContactsWithResponse(new RequestOptions().setContext(context))));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateOperation deleteCertificateOperation(String certificateName) {
        return (CertificateOperation)this.deleteCertificateOperationWithResponse(certificateName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateOperation> deleteCertificateOperationWithResponse(String certificateName, Context context) {
        return CertificateClient.callWithMappedResponseAndException(() -> this.implClient.deleteCertificateOperationWithResponse(certificateName, new RequestOptions().setContext(context)), binaryData -> CertificateOperationHelper.createCertificateOperation((com.azure.security.keyvault.certificates.implementation.models.CertificateOperation)binaryData.toObject(com.azure.security.keyvault.certificates.implementation.models.CertificateOperation.class)), CertificateAsyncClient::mapDeleteCertificateOperationException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateOperation cancelCertificateOperation(String certificateName) {
        return (CertificateOperation)this.cancelCertificateOperationWithResponse(certificateName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateOperation> cancelCertificateOperationWithResponse(String certificateName, Context context) {
        CertificateOperationUpdateParameter certificateOperationUpdateParameter = new CertificateOperationUpdateParameter(true);
        return CertificateClient.callWithMappedResponseAndException(() -> this.implClient.updateCertificateOperationWithResponse(certificateName, BinaryData.fromObject((Object)certificateOperationUpdateParameter), new RequestOptions().setContext(context)), binaryData -> CertificateOperationHelper.createCertificateOperation((com.azure.security.keyvault.certificates.implementation.models.CertificateOperation)binaryData.toObject(com.azure.security.keyvault.certificates.implementation.models.CertificateOperation.class)), CertificateAsyncClient::mapUpdateCertificateOperationException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultCertificateWithPolicy mergeCertificate(MergeCertificateOptions mergeCertificateOptions) {
        return (KeyVaultCertificateWithPolicy)this.mergeCertificateWithResponse(mergeCertificateOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultCertificateWithPolicy> mergeCertificateWithResponse(MergeCertificateOptions mergeCertificateOptions, Context context) {
        if (mergeCertificateOptions == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'mergeCertificateOptions' cannot be null."));
        }
        CertificateMergeParameters certificateMergeParameters = new CertificateMergeParameters(mergeCertificateOptions.getX509Certificates()).setTags(mergeCertificateOptions.getTags()).setCertificateAttributes(new CertificateAttributes().setEnabled(mergeCertificateOptions.isEnabled()));
        Response<BinaryData> response = this.implClient.mergeCertificateWithResponse(mergeCertificateOptions.getName(), BinaryData.fromObject((Object)certificateMergeParameters), new RequestOptions().setContext(context));
        return new SimpleResponse(response, (Object)KeyVaultCertificateWithPolicyHelper.createCertificateWithPolicy((CertificateBundle)((BinaryData)response.getValue()).toObject(CertificateBundle.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultCertificateWithPolicy importCertificate(ImportCertificateOptions importCertificateOptions) {
        return (KeyVaultCertificateWithPolicy)this.importCertificateWithResponse(importCertificateOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultCertificateWithPolicy> importCertificateWithResponse(ImportCertificateOptions importCertificateOptions, Context context) {
        if (importCertificateOptions == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'importCertificateOptions' cannot be null."));
        }
        com.azure.security.keyvault.certificates.implementation.models.CertificatePolicy implPolicy = CertificatePolicyHelper.getImplCertificatePolicy(importCertificateOptions.getPolicy());
        CertificateImportParameters certificateImportParameters = new CertificateImportParameters(CertificateAsyncClient.transformCertificateForImport(importCertificateOptions)).setPassword(importCertificateOptions.getPassword()).setCertificatePolicy(implPolicy).setTags(importCertificateOptions.getTags()).setCertificateAttributes(new CertificateAttributes().setEnabled(importCertificateOptions.isEnabled())).setPreserveCertOrder(importCertificateOptions.isCertificateOrderPreserved());
        Response<BinaryData> response = this.implClient.importCertificateWithResponse(importCertificateOptions.getName(), BinaryData.fromObject((Object)certificateImportParameters), new RequestOptions().setContext(context));
        return new SimpleResponse(response, (Object)KeyVaultCertificateWithPolicyHelper.createCertificateWithPolicy((CertificateBundle)((BinaryData)response.getValue()).toObject(CertificateBundle.class)));
    }

    private static <T> T callWithMappedException(Supplier<T> apiCall, Function<HttpResponseException, HttpResponseException> exceptionMapper) {
        try {
            return apiCall.get();
        }
        catch (HttpResponseException e) {
            throw exceptionMapper.apply(e);
        }
    }

    private static <T, R> Response<R> callWithMappedResponseAndException(Supplier<Response<T>> apiCall, Function<T, R> responseValueMapper, Function<HttpResponseException, HttpResponseException> exceptionMapper) {
        try {
            Response<T> response = apiCall.get();
            return new SimpleResponse(response, responseValueMapper.apply(response.getValue()));
        }
        catch (HttpResponseException e) {
            throw exceptionMapper.apply(e);
        }
    }
}

