/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.security.keyvault.administration.KeyVaultAdministrationServiceVersion;
import com.azure.security.keyvault.administration.implementation.KeyVaultAdministrationClientImpl;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class RoleDefinitionsImpl {
    private final RoleDefinitionsService service;
    private final KeyVaultAdministrationClientImpl client;

    RoleDefinitionsImpl(KeyVaultAdministrationClientImpl client) {
        this.service = (RoleDefinitionsService)RestProxy.create(RoleDefinitionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    public KeyVaultAdministrationServiceVersion getServiceVersion() {
        return this.client.getServiceVersion();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> deleteWithResponseAsync(String scope, String roleDefinitionName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getVaultBaseUrl(), this.client.getServiceVersion().getVersion(), scope, roleDefinitionName, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> deleteWithResponse(String scope, String roleDefinitionName, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.deleteSync(this.client.getVaultBaseUrl(), this.client.getServiceVersion().getVersion(), scope, roleDefinitionName, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateWithResponseAsync(String scope, String roleDefinitionName, BinaryData parameters, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getVaultBaseUrl(), this.client.getServiceVersion().getVersion(), scope, roleDefinitionName, "application/json", "application/json", parameters, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateWithResponse(String scope, String roleDefinitionName, BinaryData parameters, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getVaultBaseUrl(), this.client.getServiceVersion().getVersion(), scope, roleDefinitionName, "application/json", "application/json", parameters, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getWithResponseAsync(String scope, String roleDefinitionName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getVaultBaseUrl(), this.client.getServiceVersion().getVersion(), scope, roleDefinitionName, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getWithResponse(String scope, String roleDefinitionName, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getSync(this.client.getVaultBaseUrl(), this.client.getServiceVersion().getVersion(), scope, roleDefinitionName, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listSinglePageAsync(String scope, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getVaultBaseUrl(), this.client.getServiceVersion().getVersion(), scope, "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listAsync(String scope, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.listSinglePageAsync(scope, requestOptions), nextLink -> this.listNextSinglePageAsync((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listSinglePage(String scope, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listSync(this.client.getVaultBaseUrl(), this.client.getServiceVersion().getVersion(), scope, "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> list(String scope, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable(() -> this.listSinglePage(scope, requestOptions), nextLink -> this.listNextSinglePage((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getVaultBaseUrl(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listNextSinglePage(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listNextSync(nextLink, this.client.getVaultBaseUrl(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    private List<BinaryData> getValues(BinaryData binaryData, String path) {
        try {
            Map obj = (Map)binaryData.toObject(Map.class);
            List values = (List)obj.get(path);
            return values.stream().map(BinaryData::fromObject).collect(Collectors.toList());
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private String getNextLink(BinaryData binaryData, String path) {
        try {
            Map obj = (Map)binaryData.toObject(Map.class);
            return (String)obj.get(path);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    @Host(value="{vaultBaseUrl}")
    @ServiceInterface(name="KeyVaultAdministrationClientRoleDe")
    public static interface RoleDefinitionsService {
        @Delete(value="/{scope}/providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> delete(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="scope", encoded=true) String var3, @PathParam(value="roleDefinitionName") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Delete(value="/{scope}/providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> deleteSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="scope", encoded=true) String var3, @PathParam(value="roleDefinitionName") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Put(value="/{scope}/providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> createOrUpdate(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="scope", encoded=true) String var3, @PathParam(value="roleDefinitionName") String var4, @HeaderParam(value="Content-Type") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json") BinaryData var7, RequestOptions var8, Context var9);

        @Put(value="/{scope}/providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="scope", encoded=true) String var3, @PathParam(value="roleDefinitionName") String var4, @HeaderParam(value="Content-Type") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json") BinaryData var7, RequestOptions var8, Context var9);

        @Get(value="/{scope}/providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> get(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="scope", encoded=true) String var3, @PathParam(value="roleDefinitionName") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Get(value="/{scope}/providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="scope", encoded=true) String var3, @PathParam(value="roleDefinitionName") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Get(value="/{scope}/providers/Microsoft.Authorization/roleDefinitions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> list(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="scope", encoded=true) String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/{scope}/providers/Microsoft.Authorization/roleDefinitions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="scope", encoded=true) String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="vaultBaseUrl") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="vaultBaseUrl") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);
    }
}

