/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.DefaultPollingStrategy;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingStrategy;
import com.azure.core.util.polling.PollingStrategyOptions;
import com.azure.core.util.polling.SyncDefaultPollingStrategy;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.polling.SyncPollingStrategy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.TypeReference;
import com.azure.security.keyvault.administration.KeyVaultAdministrationServiceVersion;
import com.azure.security.keyvault.administration.implementation.RoleAssignmentsImpl;
import com.azure.security.keyvault.administration.implementation.RoleDefinitionsImpl;
import com.azure.security.keyvault.administration.implementation.models.FullBackupOperation;
import com.azure.security.keyvault.administration.implementation.models.RestoreOperation;
import com.azure.security.keyvault.administration.implementation.models.SelectiveKeyRestoreOperation;
import java.time.Duration;
import reactor.core.publisher.Mono;

public final class KeyVaultAdministrationClientImpl {
    private final KeyVaultAdministrationClientService service;
    private final String vaultBaseUrl;
    private final KeyVaultAdministrationServiceVersion serviceVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final RoleDefinitionsImpl roleDefinitions;
    private final RoleAssignmentsImpl roleAssignments;

    public String getVaultBaseUrl() {
        return this.vaultBaseUrl;
    }

    public KeyVaultAdministrationServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public RoleDefinitionsImpl getRoleDefinitions() {
        return this.roleDefinitions;
    }

    public RoleAssignmentsImpl getRoleAssignments() {
        return this.roleAssignments;
    }

    public KeyVaultAdministrationClientImpl(String vaultBaseUrl, KeyVaultAdministrationServiceVersion serviceVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), vaultBaseUrl, serviceVersion);
    }

    public KeyVaultAdministrationClientImpl(HttpPipeline httpPipeline, String vaultBaseUrl, KeyVaultAdministrationServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), vaultBaseUrl, serviceVersion);
    }

    public KeyVaultAdministrationClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String vaultBaseUrl, KeyVaultAdministrationServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.vaultBaseUrl = vaultBaseUrl;
        this.serviceVersion = serviceVersion;
        this.roleDefinitions = new RoleDefinitionsImpl(this);
        this.roleAssignments = new RoleAssignmentsImpl(this);
        this.service = (KeyVaultAdministrationClientService)RestProxy.create(KeyVaultAdministrationClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> fullBackupStatusWithResponseAsync(String jobId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.fullBackupStatus(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), jobId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> fullBackupStatusWithResponse(String jobId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.fullBackupStatusSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), jobId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> fullBackupWithResponseAsync(BinaryData azureStorageBlobContainerUri, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.fullBackup(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), "application/json", "application/json", azureStorageBlobContainerUri, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> fullBackupWithResponse(BinaryData azureStorageBlobContainerUri, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.fullBackupSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), "application/json", "application/json", azureStorageBlobContainerUri, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginFullBackupAsync(BinaryData azureStorageBlobContainerUri, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.fullBackupWithResponseAsync(azureStorageBlobContainerUri, requestOptions), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginFullBackup(BinaryData azureStorageBlobContainerUri, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.fullBackupWithResponse(azureStorageBlobContainerUri, requestOptions), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FullBackupOperation, FullBackupOperation> beginFullBackupWithModelAsync(BinaryData azureStorageBlobContainerUri, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.fullBackupWithResponseAsync(azureStorageBlobContainerUri, requestOptions), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(FullBackupOperation.class), (TypeReference)TypeReference.createInstance(FullBackupOperation.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FullBackupOperation, FullBackupOperation> beginFullBackupWithModel(BinaryData azureStorageBlobContainerUri, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.fullBackupWithResponse(azureStorageBlobContainerUri, requestOptions), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(FullBackupOperation.class), (TypeReference)TypeReference.createInstance(FullBackupOperation.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> preFullBackupWithResponseAsync(BinaryData preBackupOperationParameters, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.preFullBackup(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), "application/json", "application/json", preBackupOperationParameters, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> preFullBackupWithResponse(BinaryData preBackupOperationParameters, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.preFullBackupSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), "application/json", "application/json", preBackupOperationParameters, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginPreFullBackupAsync(BinaryData preBackupOperationParameters, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.preFullBackupWithResponseAsync(preBackupOperationParameters, requestOptions), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginPreFullBackup(BinaryData preBackupOperationParameters, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.preFullBackupWithResponse(preBackupOperationParameters, requestOptions), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FullBackupOperation, FullBackupOperation> beginPreFullBackupWithModelAsync(BinaryData preBackupOperationParameters, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.preFullBackupWithResponseAsync(preBackupOperationParameters, requestOptions), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(FullBackupOperation.class), (TypeReference)TypeReference.createInstance(FullBackupOperation.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FullBackupOperation, FullBackupOperation> beginPreFullBackupWithModel(BinaryData preBackupOperationParameters, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.preFullBackupWithResponse(preBackupOperationParameters, requestOptions), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(FullBackupOperation.class), (TypeReference)TypeReference.createInstance(FullBackupOperation.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> restoreStatusWithResponseAsync(String jobId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.restoreStatus(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), jobId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> restoreStatusWithResponse(String jobId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.restoreStatusSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), jobId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> fullRestoreOperationWithResponseAsync(BinaryData restoreBlobDetails, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.fullRestoreOperation(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), "application/json", "application/json", restoreBlobDetails, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> fullRestoreOperationWithResponse(BinaryData restoreBlobDetails, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.fullRestoreOperationSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), "application/json", "application/json", restoreBlobDetails, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginFullRestoreOperationAsync(BinaryData restoreBlobDetails, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.fullRestoreOperationWithResponseAsync(restoreBlobDetails, requestOptions), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginFullRestoreOperation(BinaryData restoreBlobDetails, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.fullRestoreOperationWithResponse(restoreBlobDetails, requestOptions), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<RestoreOperation, RestoreOperation> beginFullRestoreOperationWithModelAsync(BinaryData restoreBlobDetails, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.fullRestoreOperationWithResponseAsync(restoreBlobDetails, requestOptions), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(RestoreOperation.class), (TypeReference)TypeReference.createInstance(RestoreOperation.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<RestoreOperation, RestoreOperation> beginFullRestoreOperationWithModel(BinaryData restoreBlobDetails, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.fullRestoreOperationWithResponse(restoreBlobDetails, requestOptions), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(RestoreOperation.class), (TypeReference)TypeReference.createInstance(RestoreOperation.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> preFullRestoreOperationWithResponseAsync(BinaryData preRestoreOperationParameters, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.preFullRestoreOperation(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), "application/json", "application/json", preRestoreOperationParameters, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> preFullRestoreOperationWithResponse(BinaryData preRestoreOperationParameters, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.preFullRestoreOperationSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), "application/json", "application/json", preRestoreOperationParameters, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginPreFullRestoreOperationAsync(BinaryData preRestoreOperationParameters, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.preFullRestoreOperationWithResponseAsync(preRestoreOperationParameters, requestOptions), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginPreFullRestoreOperation(BinaryData preRestoreOperationParameters, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.preFullRestoreOperationWithResponse(preRestoreOperationParameters, requestOptions), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<RestoreOperation, RestoreOperation> beginPreFullRestoreOperationWithModelAsync(BinaryData preRestoreOperationParameters, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.preFullRestoreOperationWithResponseAsync(preRestoreOperationParameters, requestOptions), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(RestoreOperation.class), (TypeReference)TypeReference.createInstance(RestoreOperation.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<RestoreOperation, RestoreOperation> beginPreFullRestoreOperationWithModel(BinaryData preRestoreOperationParameters, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.preFullRestoreOperationWithResponse(preRestoreOperationParameters, requestOptions), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(RestoreOperation.class), (TypeReference)TypeReference.createInstance(RestoreOperation.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> selectiveKeyRestoreStatusWithResponseAsync(String jobId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.selectiveKeyRestoreStatus(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), jobId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> selectiveKeyRestoreStatusWithResponse(String jobId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.selectiveKeyRestoreStatusSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), jobId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> selectiveKeyRestoreOperationWithResponseAsync(String keyName, BinaryData restoreBlobDetails, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.selectiveKeyRestoreOperation(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), keyName, "application/json", "application/json", restoreBlobDetails, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> selectiveKeyRestoreOperationWithResponse(String keyName, BinaryData restoreBlobDetails, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.selectiveKeyRestoreOperationSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), keyName, "application/json", "application/json", restoreBlobDetails, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginSelectiveKeyRestoreOperationAsync(String keyName, BinaryData restoreBlobDetails, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.selectiveKeyRestoreOperationWithResponseAsync(keyName, restoreBlobDetails, requestOptions), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginSelectiveKeyRestoreOperation(String keyName, BinaryData restoreBlobDetails, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.selectiveKeyRestoreOperationWithResponse(keyName, restoreBlobDetails, requestOptions), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<SelectiveKeyRestoreOperation, SelectiveKeyRestoreOperation> beginSelectiveKeyRestoreOperationWithModelAsync(String keyName, BinaryData restoreBlobDetails, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.selectiveKeyRestoreOperationWithResponseAsync(keyName, restoreBlobDetails, requestOptions), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(SelectiveKeyRestoreOperation.class), (TypeReference)TypeReference.createInstance(SelectiveKeyRestoreOperation.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<SelectiveKeyRestoreOperation, SelectiveKeyRestoreOperation> beginSelectiveKeyRestoreOperationWithModel(String keyName, BinaryData restoreBlobDetails, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.selectiveKeyRestoreOperationWithResponse(keyName, restoreBlobDetails, requestOptions), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(SelectiveKeyRestoreOperation.class), (TypeReference)TypeReference.createInstance(SelectiveKeyRestoreOperation.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> updateSettingWithResponseAsync(String settingName, BinaryData parameters, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateSetting(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), settingName, "application/json", "application/json", parameters, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> updateSettingWithResponse(String settingName, BinaryData parameters, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateSettingSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), settingName, "application/json", "application/json", parameters, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getSettingWithResponseAsync(String settingName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSetting(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), settingName, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getSettingWithResponse(String settingName, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getSettingSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), settingName, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getSettingsWithResponseAsync(RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSettings(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getSettingsWithResponse(RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getSettingsSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
    }

    @Host(value="{vaultBaseUrl}")
    @ServiceInterface(name="KeyVaultAdministrationClient")
    public static interface KeyVaultAdministrationClientService {
        @Get(value="/backup/{jobId}/pending")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> fullBackupStatus(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/backup/{jobId}/pending")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> fullBackupStatusSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Post(value="/backup")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> fullBackup(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Post(value="/backup")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> fullBackupSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Post(value="/prebackup")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> preFullBackup(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Post(value="/prebackup")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> preFullBackupSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Get(value="/restore/{jobId}/pending")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> restoreStatus(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/restore/{jobId}/pending")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> restoreStatusSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Put(value="/restore")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> fullRestoreOperation(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Put(value="/restore")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> fullRestoreOperationSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Put(value="/prerestore")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> preFullRestoreOperation(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Put(value="/prerestore")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> preFullRestoreOperationSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Get(value="/restore/{jobId}/pending")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> selectiveKeyRestoreStatus(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/restore/{jobId}/pending")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> selectiveKeyRestoreStatusSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Put(value="/keys/{keyName}/restore")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> selectiveKeyRestoreOperation(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="keyName") String var3, @HeaderParam(value="Content-Type") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") BinaryData var6, RequestOptions var7, Context var8);

        @Put(value="/keys/{keyName}/restore")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> selectiveKeyRestoreOperationSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="keyName") String var3, @HeaderParam(value="Content-Type") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") BinaryData var6, RequestOptions var7, Context var8);

        @Patch(value="/settings/{setting-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> updateSetting(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="setting-name") String var3, @HeaderParam(value="Content-Type") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") BinaryData var6, RequestOptions var7, Context var8);

        @Patch(value="/settings/{setting-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> updateSettingSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="setting-name") String var3, @HeaderParam(value="Content-Type") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") BinaryData var6, RequestOptions var7, Context var8);

        @Get(value="/settings/{setting-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getSetting(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="setting-name") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/settings/{setting-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getSettingSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="setting-name") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/settings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getSettings(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/settings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getSettingsSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);
    }
}

