/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import com.azure.core.util.polling.SyncPoller;
import com.azure.security.keyvault.administration.KeyVaultAdministrationServiceVersion;
import com.azure.security.keyvault.administration.KeyVaultAdministrationUtil;
import com.azure.security.keyvault.administration.KeyVaultBackupClientBuilder;
import com.azure.security.keyvault.administration.implementation.KeyVaultAdministrationClientImpl;
import com.azure.security.keyvault.administration.implementation.models.FullBackupOperation;
import com.azure.security.keyvault.administration.implementation.models.PreBackupOperationParameters;
import com.azure.security.keyvault.administration.implementation.models.PreRestoreOperationParameters;
import com.azure.security.keyvault.administration.implementation.models.RestoreOperation;
import com.azure.security.keyvault.administration.implementation.models.RestoreOperationParameters;
import com.azure.security.keyvault.administration.implementation.models.SASTokenParameter;
import com.azure.security.keyvault.administration.implementation.models.SelectiveKeyRestoreOperation;
import com.azure.security.keyvault.administration.implementation.models.SelectiveKeyRestoreOperationParameters;
import com.azure.security.keyvault.administration.models.KeyVaultBackupOperation;
import com.azure.security.keyvault.administration.models.KeyVaultRestoreOperation;
import com.azure.security.keyvault.administration.models.KeyVaultRestoreResult;
import com.azure.security.keyvault.administration.models.KeyVaultSelectiveKeyRestoreOperation;
import com.azure.security.keyvault.administration.models.KeyVaultSelectiveKeyRestoreResult;
import java.net.URL;
import java.time.Duration;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;

@ServiceClient(builder=KeyVaultBackupClientBuilder.class)
public final class KeyVaultBackupClient {
    private static final ClientLogger LOGGER = new ClientLogger(KeyVaultBackupClient.class);
    private static final Duration DEFAULT_POLLING_INTERVAL = Duration.ofSeconds(1L);
    private final KeyVaultAdministrationClientImpl clientImpl;
    private final String vaultUrl;

    Duration getDefaultPollingInterval() {
        return DEFAULT_POLLING_INTERVAL;
    }

    KeyVaultBackupClient(URL vaultUrl, HttpPipeline httpPipeline, KeyVaultAdministrationServiceVersion serviceVersion) {
        Objects.requireNonNull(vaultUrl, "Azure Key Vault endpoint url is required.");
        this.vaultUrl = vaultUrl.toString();
        this.clientImpl = new KeyVaultAdministrationClientImpl(httpPipeline, this.vaultUrl, serviceVersion);
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<KeyVaultBackupOperation, String> beginBackup(String blobStorageUrl, String sasToken) {
        if (blobStorageUrl == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException(String.format("%s cannot be null.", "'blobStorageUrl'")));
        }
        return SyncPoller.createPoller((Duration)this.getDefaultPollingInterval(), cxt -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)this.backupActivationOperation(blobStorageUrl, sasToken, Context.NONE).apply((PollingContext<KeyVaultBackupOperation>)cxt)), this.backupPollOperation(Context.NONE), (pollingContext, firstResponse) -> {
            throw LOGGER.logExceptionAsError(new RuntimeException("Cancellation is not supported"));
        }, this.backupFetchOperation());
    }

    Response<KeyVaultBackupOperation> backupWithResponse(String blobStorageUrl, String sasToken, Context context) {
        SASTokenParameter sasTokenParameter = new SASTokenParameter(blobStorageUrl).setToken(sasToken).setUseManagedIdentity(sasToken == null);
        try {
            Response<BinaryData> backupOperationResponse = this.clientImpl.fullBackupWithResponse(BinaryData.fromObject((Object)sasTokenParameter), new RequestOptions().setContext(context));
            return new SimpleResponse(backupOperationResponse.getRequest(), backupOperationResponse.getStatusCode(), backupOperationResponse.getHeaders(), (Object)((KeyVaultBackupOperation)KeyVaultAdministrationUtil.transformToLongRunningOperation((FullBackupOperation)((BinaryData)backupOperationResponse.getValue()).toObject(FullBackupOperation.class))));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    private Function<PollingContext<KeyVaultBackupOperation>, KeyVaultBackupOperation> backupActivationOperation(String blobStorageUrl, String sasToken, Context context) {
        return pollingContext -> {
            try {
                return (KeyVaultBackupOperation)this.backupWithResponse(blobStorageUrl, sasToken, context).getValue();
            }
            catch (RuntimeException e) {
                throw LOGGER.logExceptionAsError(e);
            }
        };
    }

    private Function<PollingContext<KeyVaultBackupOperation>, PollResponse<KeyVaultBackupOperation>> backupPollOperation(Context context) {
        return pollingContext -> {
            try {
                PollResponse pollResponse = pollingContext.getLatestResponse();
                if (pollResponse.getStatus() == LongRunningOperationStatus.SUCCESSFULLY_COMPLETED || pollResponse.getStatus() == LongRunningOperationStatus.FAILED) {
                    return pollResponse;
                }
                KeyVaultBackupOperation keyVaultBackupOperation = (KeyVaultBackupOperation)pollResponse.getValue();
                if (keyVaultBackupOperation == null) {
                    LOGGER.warning("Backup operation does not exist. Activation operation failed.");
                    return new PollResponse(LongRunningOperationStatus.fromString((String)"BACKUP_START_FAILED", (boolean)true), null);
                }
                String jobId = keyVaultBackupOperation.getOperationId();
                Response<BinaryData> backupOperationResponse = this.clientImpl.fullBackupStatusWithResponse(jobId, new RequestOptions().setContext(context));
                return KeyVaultBackupClient.processBackupOperationResponse((Response<KeyVaultBackupOperation>)new SimpleResponse(backupOperationResponse, (Object)((KeyVaultBackupOperation)KeyVaultAdministrationUtil.transformToLongRunningOperation((FullBackupOperation)((BinaryData)backupOperationResponse.getValue()).toObject(FullBackupOperation.class)))));
            }
            catch (HttpResponseException e) {
                LOGGER.logExceptionAsError((RuntimeException)((Object)e));
                return new PollResponse(LongRunningOperationStatus.FAILED, null);
            }
            catch (RuntimeException e) {
                throw LOGGER.logExceptionAsError(e);
            }
        };
    }

    private Function<PollingContext<KeyVaultBackupOperation>, String> backupFetchOperation() {
        return pollingContext -> {
            try {
                return ((KeyVaultBackupOperation)pollingContext.getLatestResponse().getValue()).getAzureStorageBlobContainerUrl();
            }
            catch (RuntimeException e) {
                throw LOGGER.logExceptionAsError(e);
            }
        };
    }

    private static PollResponse<KeyVaultBackupOperation> processBackupOperationResponse(Response<KeyVaultBackupOperation> response) {
        String operationStatus = ((KeyVaultBackupOperation)response.getValue()).getStatus().toLowerCase(Locale.US);
        return new PollResponse(KeyVaultAdministrationUtil.toLongRunningOperationStatus(operationStatus.toLowerCase(Locale.US)), (Object)((KeyVaultBackupOperation)response.getValue()));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<KeyVaultBackupOperation, String> beginPreBackup(String blobStorageUrl, String sasToken) {
        if (blobStorageUrl == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException(String.format("%s cannot be null.", "'blobStorageUrl'")));
        }
        return SyncPoller.createPoller((Duration)this.getDefaultPollingInterval(), cxt -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)this.preBackupActivationOperation(blobStorageUrl, sasToken, Context.NONE).apply((PollingContext<KeyVaultBackupOperation>)cxt)), this.backupPollOperation(Context.NONE), (pollingContext, firstResponse) -> {
            throw LOGGER.logExceptionAsError(new RuntimeException("Cancellation is not supported"));
        }, this.backupFetchOperation());
    }

    private Function<PollingContext<KeyVaultBackupOperation>, KeyVaultBackupOperation> preBackupActivationOperation(String blobStorageUrl, String sasToken, Context context) {
        return pollingContext -> {
            try {
                return (KeyVaultBackupOperation)this.preBackupWithResponse(blobStorageUrl, sasToken, context).getValue();
            }
            catch (RuntimeException e) {
                throw LOGGER.logExceptionAsError(e);
            }
        };
    }

    Response<KeyVaultBackupOperation> preBackupWithResponse(String blobStorageUrl, String sasToken, Context context) {
        PreBackupOperationParameters preBackupOperationParameters = new PreBackupOperationParameters().setStorageResourceUri(blobStorageUrl).setToken(sasToken).setUseManagedIdentity(sasToken == null);
        try {
            Response<BinaryData> backupOperationResponse = this.clientImpl.preFullBackupWithResponse(BinaryData.fromObject((Object)preBackupOperationParameters), new RequestOptions().setContext(context));
            return new SimpleResponse(backupOperationResponse.getRequest(), backupOperationResponse.getStatusCode(), backupOperationResponse.getHeaders(), (Object)((KeyVaultBackupOperation)KeyVaultAdministrationUtil.transformToLongRunningOperation((FullBackupOperation)((BinaryData)backupOperationResponse.getValue()).toObject(FullBackupOperation.class))));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<KeyVaultRestoreOperation, KeyVaultRestoreResult> beginRestore(String folderUrl, String sasToken) {
        if (folderUrl == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException(String.format("%s cannot be null.", "'folderUrl'")));
        }
        return SyncPoller.createPoller((Duration)this.getDefaultPollingInterval(), context -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)this.restoreActivationOperation(folderUrl, sasToken, Context.NONE).apply((PollingContext<KeyVaultRestoreOperation>)context)), this.restorePollOperation(Context.NONE), (pollingContext, firstResponse) -> {
            throw LOGGER.logExceptionAsError(new RuntimeException("Cancellation is not supported"));
        }, pollingContext -> new KeyVaultRestoreResult());
    }

    Response<KeyVaultRestoreOperation> restoreWithResponse(String folderUrl, String sasToken, Context context) {
        String[] segments = folderUrl.split("/");
        String folderName = segments[segments.length - 1];
        String containerUrl = folderUrl.substring(0, folderUrl.length() - folderName.length());
        SASTokenParameter sasTokenParameter = new SASTokenParameter(containerUrl).setToken(sasToken).setUseManagedIdentity(sasToken == null);
        RestoreOperationParameters restoreOperationParameters = new RestoreOperationParameters(sasTokenParameter, folderName);
        try {
            Response<BinaryData> restoreOperationResponse = this.clientImpl.fullRestoreOperationWithResponse(BinaryData.fromObject((Object)restoreOperationParameters), new RequestOptions().setContext(context));
            return new SimpleResponse(restoreOperationResponse.getRequest(), restoreOperationResponse.getStatusCode(), restoreOperationResponse.getHeaders(), (Object)((KeyVaultRestoreOperation)KeyVaultAdministrationUtil.transformToLongRunningOperation((RestoreOperation)((BinaryData)restoreOperationResponse.getValue()).toObject(RestoreOperation.class))));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    private Function<PollingContext<KeyVaultRestoreOperation>, KeyVaultRestoreOperation> restoreActivationOperation(String folderUrl, String sasToken, Context context) {
        return pollingContext -> {
            try {
                return (KeyVaultRestoreOperation)this.restoreWithResponse(folderUrl, sasToken, context).getValue();
            }
            catch (RuntimeException e) {
                throw LOGGER.logExceptionAsError(e);
            }
        };
    }

    private Function<PollingContext<KeyVaultRestoreOperation>, PollResponse<KeyVaultRestoreOperation>> restorePollOperation(Context context) {
        return pollingContext -> {
            try {
                PollResponse pollResponse = pollingContext.getLatestResponse();
                if (pollResponse.getStatus() == LongRunningOperationStatus.SUCCESSFULLY_COMPLETED || pollResponse.getStatus() == LongRunningOperationStatus.FAILED) {
                    return pollResponse;
                }
                KeyVaultRestoreOperation keyVaultRestoreOperation = (KeyVaultRestoreOperation)pollResponse.getValue();
                if (keyVaultRestoreOperation == null) {
                    LOGGER.warning("Restore operation does not exist. Activation operation failed.");
                    return new PollResponse(LongRunningOperationStatus.fromString((String)"RESTORE_START_FAILED", (boolean)true), null);
                }
                String jobId = keyVaultRestoreOperation.getOperationId();
                Response<BinaryData> response = this.clientImpl.restoreStatusWithResponse(jobId, new RequestOptions().setContext(context));
                return KeyVaultBackupClient.processRestoreOperationResponse((Response<KeyVaultRestoreOperation>)new SimpleResponse(response, (Object)((KeyVaultRestoreOperation)KeyVaultAdministrationUtil.transformToLongRunningOperation((RestoreOperation)((BinaryData)response.getValue()).toObject(RestoreOperation.class)))));
            }
            catch (HttpResponseException e) {
                LOGGER.logExceptionAsError((RuntimeException)((Object)e));
                return new PollResponse(LongRunningOperationStatus.FAILED, null);
            }
            catch (RuntimeException e) {
                throw LOGGER.logExceptionAsError(e);
            }
        };
    }

    private static PollResponse<KeyVaultRestoreOperation> processRestoreOperationResponse(Response<KeyVaultRestoreOperation> response) {
        String operationStatus = ((KeyVaultRestoreOperation)response.getValue()).getStatus().toLowerCase(Locale.US);
        return new PollResponse(KeyVaultAdministrationUtil.toLongRunningOperationStatus(operationStatus.toLowerCase(Locale.US)), (Object)((KeyVaultRestoreOperation)response.getValue()));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<KeyVaultRestoreOperation, KeyVaultRestoreResult> beginPreRestore(String folderUrl, String sasToken) {
        if (folderUrl == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException(String.format("%s cannot be null.", "'folderUrl'")));
        }
        Context context = Context.NONE;
        return SyncPoller.createPoller((Duration)this.getDefaultPollingInterval(), cxt -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)this.preRestoreActivationOperation(folderUrl, sasToken, context).apply((PollingContext<KeyVaultRestoreOperation>)cxt)), this.restorePollOperation(context), (pollingContext, firstResponse) -> {
            throw LOGGER.logExceptionAsError(new RuntimeException("Cancellation is not supported"));
        }, pollingContext -> new KeyVaultRestoreResult());
    }

    Response<KeyVaultRestoreOperation> preRestoreWithResponse(String folderUrl, String sasToken, Context context) {
        String[] segments = folderUrl.split("/");
        String folderName = segments[segments.length - 1];
        String containerUrl = folderUrl.substring(0, folderUrl.length() - folderName.length());
        SASTokenParameter sasTokenParameter = new SASTokenParameter(containerUrl).setToken(sasToken).setUseManagedIdentity(sasToken == null);
        PreRestoreOperationParameters restoreOperationParameters = new PreRestoreOperationParameters().setFolderToRestore(folderName).setSasTokenParameters(sasTokenParameter);
        try {
            Response<BinaryData> restoreOperationResponse = this.clientImpl.preFullRestoreOperationWithResponse(BinaryData.fromObject((Object)restoreOperationParameters), new RequestOptions().setContext(context));
            return new SimpleResponse(restoreOperationResponse.getRequest(), restoreOperationResponse.getStatusCode(), restoreOperationResponse.getHeaders(), (Object)((KeyVaultRestoreOperation)KeyVaultAdministrationUtil.transformToLongRunningOperation((RestoreOperation)((BinaryData)restoreOperationResponse.getValue()).toObject(RestoreOperation.class))));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    private Function<PollingContext<KeyVaultRestoreOperation>, KeyVaultRestoreOperation> preRestoreActivationOperation(String folderUrl, String sasToken, Context context) {
        return pollingContext -> {
            try {
                return (KeyVaultRestoreOperation)this.preRestoreWithResponse(folderUrl, sasToken, context).getValue();
            }
            catch (RuntimeException e) {
                throw LOGGER.logExceptionAsError(e);
            }
        };
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<KeyVaultSelectiveKeyRestoreOperation, KeyVaultSelectiveKeyRestoreResult> beginSelectiveKeyRestore(String keyName, String folderUrl, String sasToken) {
        if (keyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException(String.format("%s cannot be null.", "'keyName'")));
        }
        if (folderUrl == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException(String.format("%s cannot be null.", "'folderUrl'")));
        }
        return SyncPoller.createPoller((Duration)this.getDefaultPollingInterval(), context -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)this.selectiveKeyRestoreActivationOperation(keyName, folderUrl, sasToken, Context.NONE).apply((PollingContext<KeyVaultSelectiveKeyRestoreOperation>)context)), this.selectiveKeyRestorePollOperation(Context.NONE), (pollingContext, firstResponse) -> {
            throw LOGGER.logExceptionAsError(new RuntimeException("Cancellation is not supported"));
        }, pollingContext -> new KeyVaultSelectiveKeyRestoreResult());
    }

    Response<KeyVaultSelectiveKeyRestoreOperation> selectiveKeyRestoreWithResponse(String keyName, String folderUrl, String sasToken, Context context) {
        String[] segments = folderUrl.split("/");
        String folderName = segments[segments.length - 1];
        String containerUrl = folderUrl.substring(0, folderUrl.length() - folderName.length());
        SASTokenParameter sasTokenParameter = new SASTokenParameter(containerUrl).setToken(sasToken).setUseManagedIdentity(sasToken == null);
        SelectiveKeyRestoreOperationParameters selectiveKeyRestoreOperationParameters = new SelectiveKeyRestoreOperationParameters(sasTokenParameter, folderName);
        try {
            Response<BinaryData> selectiveKeyRestoreOperationResponse = this.clientImpl.selectiveKeyRestoreOperationWithResponse(keyName, BinaryData.fromObject((Object)selectiveKeyRestoreOperationParameters), new RequestOptions().setContext(context));
            return new SimpleResponse(selectiveKeyRestoreOperationResponse.getRequest(), selectiveKeyRestoreOperationResponse.getStatusCode(), selectiveKeyRestoreOperationResponse.getHeaders(), (Object)((KeyVaultSelectiveKeyRestoreOperation)KeyVaultAdministrationUtil.transformToLongRunningOperation((SelectiveKeyRestoreOperation)((BinaryData)selectiveKeyRestoreOperationResponse.getValue()).toObject(SelectiveKeyRestoreOperation.class))));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    private Function<PollingContext<KeyVaultSelectiveKeyRestoreOperation>, KeyVaultSelectiveKeyRestoreOperation> selectiveKeyRestoreActivationOperation(String keyName, String folderUrl, String sasToken, Context context) {
        return pollingContext -> {
            try {
                return (KeyVaultSelectiveKeyRestoreOperation)this.selectiveKeyRestoreWithResponse(keyName, folderUrl, sasToken, context).getValue();
            }
            catch (RuntimeException e) {
                throw LOGGER.logExceptionAsError(e);
            }
        };
    }

    private Function<PollingContext<KeyVaultSelectiveKeyRestoreOperation>, PollResponse<KeyVaultSelectiveKeyRestoreOperation>> selectiveKeyRestorePollOperation(Context context) {
        return pollingContext -> {
            try {
                PollResponse pollResponse = pollingContext.getLatestResponse();
                if (pollResponse.getStatus() == LongRunningOperationStatus.SUCCESSFULLY_COMPLETED || pollResponse.getStatus() == LongRunningOperationStatus.FAILED) {
                    return pollResponse;
                }
                KeyVaultSelectiveKeyRestoreOperation keyVaultSelectiveKeyRestoreOperation = (KeyVaultSelectiveKeyRestoreOperation)pollResponse.getValue();
                if (keyVaultSelectiveKeyRestoreOperation == null) {
                    LOGGER.warning("Restore operation does not exist. Activation operation failed.");
                    return new PollResponse(LongRunningOperationStatus.fromString((String)"SELECTIVE_RESTORE_START_FAILED", (boolean)true), null);
                }
                String jobId = keyVaultSelectiveKeyRestoreOperation.getOperationId();
                Response<BinaryData> response = this.clientImpl.selectiveKeyRestoreStatusWithResponse(jobId, new RequestOptions().setContext(context));
                return KeyVaultBackupClient.processSelectiveKeyRestoreOperationResponse((Response<KeyVaultSelectiveKeyRestoreOperation>)new SimpleResponse(response, (Object)((KeyVaultSelectiveKeyRestoreOperation)KeyVaultAdministrationUtil.transformToLongRunningOperation((SelectiveKeyRestoreOperation)((BinaryData)response.getValue()).toObject(SelectiveKeyRestoreOperation.class)))));
            }
            catch (HttpResponseException e) {
                LOGGER.logExceptionAsError((RuntimeException)((Object)e));
                return new PollResponse(LongRunningOperationStatus.FAILED, null);
            }
            catch (RuntimeException e) {
                throw LOGGER.logExceptionAsError(e);
            }
        };
    }

    private static PollResponse<KeyVaultSelectiveKeyRestoreOperation> processSelectiveKeyRestoreOperationResponse(Response<KeyVaultSelectiveKeyRestoreOperation> response) {
        String operationStatus = ((KeyVaultSelectiveKeyRestoreOperation)response.getValue()).getStatus().toLowerCase(Locale.US);
        return new PollResponse(KeyVaultAdministrationUtil.toLongRunningOperationStatus(operationStatus.toLowerCase(Locale.US)), (Object)((KeyVaultSelectiveKeyRestoreOperation)response.getValue()));
    }
}

