/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.administration.models.KeyVaultSettingType;
import java.io.IOException;
import java.util.ArrayList;

public final class Setting
implements JsonSerializable<Setting> {
    private final String name;
    private final String value;
    private KeyVaultSettingType type;

    public Setting(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public KeyVaultSettingType getType() {
        return this.type;
    }

    public Setting setType(KeyVaultSettingType type) {
        this.type = type;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static Setting fromJson(JsonReader jsonReader) throws IOException {
        return (Setting)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            boolean valueFound = false;
            String value = null;
            KeyVaultSettingType type = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("value".equals(fieldName)) {
                    value = reader.getString();
                    valueFound = true;
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = KeyVaultSettingType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound && valueFound) {
                Setting deserializedSetting = new Setting(name, value);
                deserializedSetting.type = type;
                return deserializedSetting;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!valueFound) {
                missingProperties.add("value");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

